/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;

public class EntityUtils {
    private static EnumFacing[] facings = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.UP, EnumFacing.DOWN};
    private static Field playersWatchingChunk;

    public static void spawnEjectedItem(World world, BlockPos pos, ItemStack itemStack) {
        if (itemStack == null || world.field_72995_K) {
            return;
        }
        float rx = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float ry = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float rz = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + rx), (double)((float)pos.func_177956_o() + ry), (double)((float)pos.func_177952_p() + rz), itemStack);
        float factor = 0.05f;
        entityItem.field_70159_w = world.field_73012_v.nextGaussian() * (double)factor;
        entityItem.field_70181_x = world.field_73012_v.nextGaussian() * (double)factor + (double)0.2f;
        entityItem.field_70179_y = world.field_73012_v.nextGaussian() * (double)factor;
        world.func_72838_d((Entity)entityItem);
    }

    public static EntityPlayerMP findPlayerFromUUID(UUID uuid) {
        return null;
    }

    public static EnumFacing getEntityFacing(Entity entity) {
        return EntityUtils.getEntityFacing(entity, false);
    }

    public static EnumFacing getEntityFacing(Entity entity, boolean sixWays) {
        return facings[EntityUtils.getEntityRotation(entity, sixWays)];
    }

    public static int getEntityRotation(Entity entity) {
        return EntityUtils.getEntityRotation(entity, false);
    }

    public static int getEntityRotation(Entity entity, boolean sixWays) {
        if (entity == null) {
            return 6;
        }
        float pitch = entity.field_70125_A;
        if (sixWays && pitch < -45.0f) {
            return 4;
        }
        if (sixWays && pitch > 45.0f) {
            return 5;
        }
        return MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) + 2 & 3;
    }

    public static boolean isEquipped(EntityPlayer player, Item item, EnumHand hand) {
        return player != null && player.func_184586_b(hand) != null && player.func_184614_ca().func_77973_b() == item;
    }

    public static boolean isEquipped(EntityPlayer player, ItemStack itemStack, EnumHand hand) {
        return EntityUtils.isEquipped(player, itemStack != null ? itemStack.func_77973_b() : null, hand);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(Chunk chunk) {
        return EntityUtils.getPlayersWatchingChunk((WorldServer)chunk.func_177412_p(), chunk.field_76635_g, chunk.field_76647_h);
    }

    public static List<EntityPlayerMP> getPlayersWatchingChunk(WorldServer world, int x, int z) {
        if (playersWatchingChunk == null) {
            return new ArrayList<EntityPlayerMP>();
        }
        try {
            PlayerChunkMapEntry entry = world.func_184164_w().func_187301_b(x, z);
            if (entry == null) {
                return Lists.newArrayList();
            }
            return (List)playersWatchingChunk.get(entry);
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.info("Failed to get players watching chunk :", (Throwable)e);
            return new ArrayList<EntityPlayerMP>();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addDestroyEffects(World world, BlockPos pos, ParticleManager particleManager, IBlockState ... states) {
        if (ArrayUtils.isEmpty((Object[])states)) {
            states = new IBlockState[]{world.func_180495_p(pos)};
        }
        int nb = 4;
        ParticleDigging.Factory factory = new ParticleDigging.Factory();
        for (int i = 0; i < nb; ++i) {
            for (int j = 0; j < nb; ++j) {
                for (int k = 0; k < nb; ++k) {
                    double fxX = (double)pos.func_177958_n() + ((double)i + 0.5) / (double)nb;
                    double fxY = (double)pos.func_177956_o() + ((double)j + 0.5) / (double)nb;
                    double fxZ = (double)pos.func_177952_p() + ((double)k + 0.5) / (double)nb;
                    int id = Block.func_176210_f((IBlockState)states[world.field_73012_v.nextInt(states.length)]);
                    ParticleDigging fx = (ParticleDigging)factory.func_178902_a(0, world, fxX, fxY, fxZ, fxX - (double)pos.func_177958_n() - 0.5, fxY - (double)pos.func_177956_o() - 0.5, fxZ - (double)pos.func_177952_p() - 0.5, new int[]{id});
                    particleManager.func_78873_a((Particle)fx);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addHitEffects(World world, RayTraceResult target, ParticleManager particleManager, IBlockState ... states) {
        IBlockState baseState;
        BlockPos pos = target.func_178782_a();
        if (ArrayUtils.isEmpty((Object[])states)) {
            states = new IBlockState[]{world.func_180495_p(pos)};
        }
        if ((baseState = world.func_180495_p(pos)).func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            return;
        }
        double fxX = (double)pos.func_177958_n() + world.field_73012_v.nextDouble();
        double fxY = (double)pos.func_177956_o() + world.field_73012_v.nextDouble();
        double fxZ = (double)pos.func_177952_p() + world.field_73012_v.nextDouble();
        AxisAlignedBB aabb = baseState.func_185900_c((IBlockAccess)world, pos);
        switch (target.field_178784_b) {
            case DOWN: {
                fxY = (double)pos.func_177956_o() + aabb.field_72338_b - (double)0.1f;
                break;
            }
            case UP: {
                fxY = (double)pos.func_177956_o() + aabb.field_72337_e + (double)0.1f;
                break;
            }
            case NORTH: {
                fxZ = (double)pos.func_177952_p() + aabb.field_72339_c - (double)0.1f;
                break;
            }
            case SOUTH: {
                fxZ = (double)pos.func_177952_p() + aabb.field_72337_e + (double)0.1f;
                break;
            }
            case EAST: {
                fxX = (double)pos.func_177958_n() + aabb.field_72336_d + (double)0.1f;
                break;
            }
            case WEST: {
                fxX = (double)pos.func_177958_n() + aabb.field_72340_a + (double)0.1f;
                break;
            }
        }
        int id = Block.func_176210_f((IBlockState)states[world.field_73012_v.nextInt(states.length)]);
        ParticleDigging.Factory factory = new ParticleDigging.Factory();
        ParticleDigging fx = (ParticleDigging)factory.func_178902_a(0, world, fxX, fxY, fxZ, 0.0, 0.0, 0.0, new int[]{id});
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        particleManager.func_78873_a((Particle)fx);
    }

    static {
        try {
            Class<?> clazz = Class.forName("net.minecraft.server.management.PlayerChunkMapEntry");
            playersWatchingChunk = AsmUtils.changeFieldAccess(clazz, "players", "field_187283_c");
        }
        catch (ClassNotFoundException e) {
            MalisisCore.log.error("Failed to get PlayerChunkMap class.", (Throwable)e);
        }
    }
}

