/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.component;

import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.IRenderComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.model.MalisisModel;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class ModelComponent
implements IRenderComponent {
    protected ResourceLocation resourceLocation;
    protected MalisisModel model;

    public ModelComponent(String modelName) {
        this.resourceLocation = new ResourceLocation(modelName);
        this.loadModel();
    }

    protected void loadModel() {
        this.model = new MalisisModel(this.resourceLocation);
    }

    public MalisisModel getModel() {
        return this.model;
    }

    @Override
    public void render(Block block, MalisisRenderer<TileEntity> renderer) {
        this.model.resetState();
        this.model.rotate(DirectionalComponent.getDirection(renderer.getBlockState()));
        this.model.render(renderer);
    }
}

