/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Ordering;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCommand;
import net.malisis.core.MalisisCoreSettings;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.configuration.ConfigurationGui;
import net.malisis.core.configuration.Settings;
import net.malisis.core.network.MalisisNetwork;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.registry.Registries;
import net.malisis.core.util.syncer.Syncer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.ICommand;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLStateEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="malisiscore", name="Malisis Core", version="1.10.2-4.2.0", acceptedMinecraftVersions="[1.10.2]")
public class MalisisCore
implements IMalisisMod {
    public static final int malisisRenderType = 4;
    public static final String modid = "malisiscore";
    public static final String modname = "Malisis Core";
    public static final String version = "1.10.2-4.2.0";
    public static final String url = "";
    public static MalisisCore instance;
    public static Logger log;
    public static MalisisNetwork network;
    private MalisisCoreSettings settings;
    private HashMap<String, IMalisisMod> registeredMods = new HashMap();
    public static boolean isObfEnv;

    public MalisisCore() {
        instance = this;
        network = new MalisisNetwork(this);
        isObfEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment") == false;
        MalisisCore.registerMod(this);
    }

    @Override
    public String getModId() {
        return modid;
    }

    @Override
    public String getName() {
        return modname;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    public static void registerMod(IMalisisMod mod) {
        MalisisCore.instance.registeredMods.put(mod.getModId(), mod);
    }

    public static IMalisisMod getMod(String id) {
        return MalisisCore.instance.registeredMods.get(id);
    }

    public static Set<String> listModId() {
        return MalisisCore.instance.registeredMods.keySet();
    }

    public static boolean isClient() {
        return FMLCommonHandler.instance().getSide().isClient();
    }

    private void autoLoadClasses(ASMDataTable asmDataTable) {
        ImmutableSortedSet classes = ImmutableSortedSet.copyOf((Comparator)Ordering.natural().onResultOf(ASMDataTable.ASMData::getClassName), (Collection)asmDataTable.getAll(AutoLoad.class.getName()));
        Set clientClasses = asmDataTable.getAll(SideOnly.class.getName());
        for (ASMDataTable.ASMData data : classes) {
            try {
                Class<?> clazz;
                AutoLoad anno;
                if (!MalisisCore.isClient() && this.isClientClass(data.getClassName(), clientClasses) || !(anno = (clazz = Class.forName(data.getClassName())).getAnnotation(AutoLoad.class)).value()) continue;
                clazz.newInstance();
            }
            catch (Exception e) {
                log.error("Could not autoload {}.", new Object[]{data.getClassName(), e});
            }
        }
    }

    private boolean isClientClass(String className, Set<ASMDataTable.ASMData> clientClasses) {
        for (ASMDataTable.ASMData data : clientClasses) {
            if (!data.getClassName().equals(className) || !data.getObjectName().equals(data.getClassName()) || !((ModAnnotation.EnumHolder)data.getAnnotationInfo().get("value")).getValue().equals("CLIENT")) continue;
            return true;
        }
        return false;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.autoLoadClasses(event.getAsmData());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MalisisNetwork.createMessages(event.getAsmData());
        Syncer.get().discover(event.getAsmData());
        this.settings = new MalisisCoreSettings(event.getSuggestedConfigurationFile());
        Registries.processFMLStateEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (MalisisCore.isClient()) {
            ClientCommandHandler.instance.func_71560_a((ICommand)new MalisisCommand());
        }
        Registries.processFMLStateEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        Registries.processFMLStateEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void postInit(FMLLoadCompleteEvent event) {
        Registries.processFMLStateEvent((FMLStateEvent)event);
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGuiClose(GuiOpenEvent event) {
        if (!MalisisGui.cancelClose || event.getGui() != null) {
            return;
        }
        MalisisGui.cancelClose = false;
        event.setCanceled(true);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean openConfigurationGui(IMalisisMod mod) {
        Settings settings = mod.getSettings();
        if (settings == null) {
            return false;
        }
        new ConfigurationGui(mod, settings).display(true);
        return true;
    }

    public static void message(Object text) {
        MalisisCore.message(text, new Object[]{null});
    }

    public static void message(Object text, Object ... data) {
        String txt;
        String string = txt = text != null ? text.toString() : "null";
        if (text instanceof Object[]) {
            txt = Arrays.deepToString((Object[])text);
        }
        TextComponentString msg = new TextComponentString(I18n.func_135052_a((String)txt, (Object[])data));
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            MinecraftServer server = FMLCommonHandler.instance().getSidedDelegate().getServer();
            if (server != null) {
                server.func_184103_al().func_148539_a((ITextComponent)msg);
            }
        } else {
            if (Minecraft.func_71410_x() == null || Minecraft.func_71410_x().field_71439_g == null) {
                return;
            }
            Style cs = new Style();
            cs.func_150217_b(Boolean.valueOf(true));
            cs.func_150238_a(TextFormatting.GRAY);
            msg.func_150255_a(cs);
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)msg);
        }
    }

    static {
        log = LogManager.getLogger((String)modid);
        isObfEnv = false;
    }
}

