/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import groovy.util.Node;
import groovy.util.NodeList;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.ltgt.gradle.apt.AptPlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.plugins.ide.idea.GenerateIdeaModule;
import org.gradle.plugins.ide.idea.IdeaPlugin;
import org.gradle.plugins.ide.idea.model.IdeaModel;
import org.gradle.plugins.ide.idea.model.IdeaModule;
import org.gradle.plugins.ide.idea.model.IdeaProject;

public class AptIdeaPlugin
implements Plugin<Project> {
    private static final boolean isIdeaImport = Boolean.getBoolean("idea.active") && System.getProperty("idea.version") != null;

    private static boolean classExists(String name) {
        try {
            Class.forName(name);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void apply(Project project) {
        project.getPlugins().apply(AptPlugin.class);
        project.getPlugins().apply(IdeaPlugin.class);
        project.getPlugins().withType(JavaPlugin.class, javaPlugin -> {
            JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
            SourceSet mainSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("main");
            SourceSet testSourceSet = (SourceSet)javaConvention.getSourceSets().getByName("test");
            this.configureIdeaModule(project, mainSourceSet, testSourceSet);
        });
        this.configureIdeaProject(project);
    }

    private void configureIdeaModule(Project project, SourceSet mainSourceSet, SourceSet testSourceSet) {
        IdeaModule ideaModule = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getModule();
        ModuleApt apt = new ModuleApt();
        ((ExtensionAware)ideaModule).getExtensions().add("apt", (Object)apt);
        project.afterEvaluate(project1 -> {
            if (apt.isAddGeneratedSourcesDirs()) {
                Set mainGeneratedSourcesDirs = AptPlugin.IMPL.getGeneratedSourcesDirs(mainSourceSet.getOutput()).getFiles();
                Set testGeneratedSourcesDirs = AptPlugin.IMPL.getGeneratedSourcesDirs(testSourceSet.getOutput()).getFiles();
                if (!mainGeneratedSourcesDirs.isEmpty()) {
                    ideaModule.setSourceDirs(AptIdeaPlugin.addToSet(ideaModule.getSourceDirs(), mainGeneratedSourcesDirs));
                    ideaModule.setGeneratedSourceDirs(AptIdeaPlugin.addToSet(ideaModule.getGeneratedSourceDirs(), mainGeneratedSourcesDirs));
                }
                if (!testGeneratedSourcesDirs.isEmpty()) {
                    ideaModule.setTestSourceDirs(AptIdeaPlugin.addToSet(ideaModule.getTestSourceDirs(), testGeneratedSourcesDirs));
                    ideaModule.setGeneratedSourceDirs(AptIdeaPlugin.addToSet(ideaModule.getGeneratedSourceDirs(), testGeneratedSourcesDirs));
                }
            }
            if (apt.isAddAptDependencies()) {
                Configuration annotationProcessor = project1.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(mainSourceSet));
                Configuration testAnnotationProcessor = project1.getConfigurations().getByName(AptPlugin.IMPL.getAnnotationProcessorConfigurationName(testSourceSet));
                AptIdeaPlugin.getScope(ideaModule, apt.getMainDependenciesScope(), "plus").add(annotationProcessor);
                AptIdeaPlugin.getScope(ideaModule, "TEST", "plus").add(testAnnotationProcessor);
                AptPlugin.IMPL.configureTasks((Project)project1, GenerateIdeaModule.class, generateIdeaModule -> generateIdeaModule.dependsOn(new Object[]{annotationProcessor, testAnnotationProcessor}));
            }
        });
    }

    private static Set<File> addToSet(Set<File> sourceDirs, Collection<File> dirs) {
        LinkedHashSet<File> newSet = new LinkedHashSet<File>(sourceDirs);
        newSet.addAll(dirs);
        return newSet;
    }

    private static Collection<Configuration> getScope(IdeaModule ideaModule, String scope, String plusOrMinus) {
        return (Collection)((Map)ideaModule.getScopes().get(scope)).get(plusOrMinus);
    }

    private void configureIdeaProject(Project project) {
        if (project.getParent() == null) {
            IdeaProject ideaProject = ((IdeaModel)project.getExtensions().getByType(IdeaModel.class)).getProject();
            ProjectAptConvention apt = new ProjectAptConvention();
            ((HasConvention)ideaProject).getConvention().getPlugins().put("net.ltgt.apt-idea", apt);
            ideaProject.getIpr().withXml(xmlProvider -> {
                if (!apt.isConfigureAnnotationProcessing()) {
                    return;
                }
                for (Object it : (NodeList)xmlProvider.asNode().get("component")) {
                    Node compilerConfiguration = (Node)it;
                    if (!Objects.equals(compilerConfiguration.attribute((Object)"name"), "CompilerConfiguration")) continue;
                    for (Object n : (NodeList)compilerConfiguration.get("annotationProcessing")) {
                        compilerConfiguration.remove((Node)n);
                    }
                    Node annotationProcessing = compilerConfiguration.appendNode((Object)"annotationProcessing");
                    LinkedHashMap<String, Object> profileAttributes = new LinkedHashMap<String, Object>();
                    profileAttributes.put("name", "Default");
                    profileAttributes.put("enabled", true);
                    profileAttributes.put("default", true);
                    Node profile = annotationProcessing.appendNode((Object)"profile", profileAttributes);
                    profile.appendNode((Object)"sourceOutputDir", Collections.singletonMap("name", project.relativePath((Object)project.getBuildDir()) + "/generated/sources/annotationProcessor/java/" + "main"));
                    profile.appendNode((Object)"sourceTestOutputDir", Collections.singletonMap("name", project.relativePath((Object)project.getBuildDir()) + "/generated/sources/annotationProcessor/java/" + "test"));
                    profile.appendNode((Object)"outputRelativeToContentRoot", Collections.singletonMap("value", true));
                    profile.appendNode((Object)"processorPath", Collections.singletonMap("useClasspath", true));
                }
            });
        }
    }

    static /* synthetic */ boolean access$000() {
        return isIdeaImport;
    }

    public static class ProjectAptConvention {
        private boolean configureAnnotationProcessing = true;

        public boolean isConfigureAnnotationProcessing() {
            return this.configureAnnotationProcessing;
        }

        public void setConfigureAnnotationProcessing(boolean configureAnnotationProcessing) {
            this.configureAnnotationProcessing = configureAnnotationProcessing;
        }
    }

    public static class ModuleApt {
        private boolean addGeneratedSourcesDirs = true;
        private boolean addAptDependencies = true;
        private String mainDependenciesScope = AptIdeaPlugin.access$000() ? "COMPILE" : "PROVIDED";

        public boolean isAddGeneratedSourcesDirs() {
            return this.addGeneratedSourcesDirs;
        }

        public void setAddGeneratedSourcesDirs(boolean addGeneratedSourcesDirs) {
            this.addGeneratedSourcesDirs = addGeneratedSourcesDirs;
        }

        public boolean isAddAptDependencies() {
            return this.addAptDependencies;
        }

        public void setAddAptDependencies(boolean addAptDependencies) {
            this.addAptDependencies = addAptDependencies;
        }

        public String getMainDependenciesScope() {
            return this.mainDependenciesScope;
        }

        public void setMainDependenciesScope(String mainDependenciesScope) {
            this.mainDependenciesScope = Objects.requireNonNull(mainDependenciesScope);
        }
    }
}

