/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.plugins.ide.api.PropertiesFileContentMerger;
import org.gradle.util.ConfigureUtil;

public class EclipseJdtApt {
    private final Project project;
    private final PropertiesFileContentMerger file;
    private final Property<Boolean> aptEnabled;
    private final Property<Boolean> reconcileEnabled;
    private final Property<File> genSrcDir;
    private final Property<Map<String, ?>> processorOptions;

    public EclipseJdtApt(Project project, PropertiesFileContentMerger file) {
        this.project = project;
        this.file = file;
        this.aptEnabled = project.getObjects().property(Boolean.class);
        this.aptEnabled.set((Object)true);
        this.reconcileEnabled = project.getObjects().property(Boolean.class);
        this.reconcileEnabled.set((Object)true);
        this.genSrcDir = project.getObjects().property(File.class);
        this.genSrcDir.set((Object)project.file((Object)".apt_generated"));
        this.processorOptions = project.getObjects().property(Map.class);
        this.processorOptions.set(new LinkedHashMap());
    }

    public boolean isAptEnabled() {
        return (Boolean)this.aptEnabled.get();
    }

    public void setAptEnabled(boolean aptEnabled) {
        this.aptEnabled.set((Object)aptEnabled);
    }

    public void setAptEnabled(Provider<Boolean> aptEnabled) {
        this.aptEnabled.set(aptEnabled);
    }

    public boolean isReconcileEnabled() {
        return (Boolean)this.reconcileEnabled.get();
    }

    public void setReconcileEnabled(boolean reconcileEnabled) {
        this.reconcileEnabled.set((Object)reconcileEnabled);
    }

    public void setReconcileEnabled(Provider<Boolean> reconcileEnabled) {
        this.reconcileEnabled.set(reconcileEnabled);
    }

    public File getGenSrcDir() {
        return this.project.file(this.genSrcDir);
    }

    public void setGenSrcDir(File genSrcDir) {
        this.genSrcDir.set((Object)Objects.requireNonNull(genSrcDir));
    }

    public void setGenSrcDir(Object genSrcDir) {
        Objects.requireNonNull(genSrcDir);
        this.genSrcDir.set(this.project.provider(() -> this.project.file(genSrcDir)));
    }

    @Nullable
    public Map<String, ?> getProcessorOptions() {
        return (Map)this.processorOptions.getOrNull();
    }

    public void setProcessorOptions(@Nullable Map<String, ?> processorOptions) {
        this.processorOptions.set(processorOptions);
    }

    public void setProcessorOptions(Provider<Map<String, ?>> processorOptions) {
        this.processorOptions.set(processorOptions);
    }

    public PropertiesFileContentMerger getFile() {
        return this.file;
    }

    public void file(Closure<? super PropertiesFileContentMerger> closure) {
        ConfigureUtil.configure(closure, (Object)this.file);
    }

    public void file(Action<? super PropertiesFileContentMerger> action) {
        action.execute((Object)this.file);
    }
}

