/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.plugins.ide.api.FileContentMerger;

class CompatibilityUtils {
    private static final Method taskGetInputsMethod = CompatibilityUtils.getMethod(Task.class, "getInputs", new Class[0]);
    private static final Method taskGetOutputsMethod = CompatibilityUtils.getMethod(Task.class, "getOutputs", new Class[0]);
    private static final Method taskInputsFilesMethod = CompatibilityUtils.getMethod(TaskInputs.class, "files", Object[].class);
    private static final Method taskInputsPropertyMethod = CompatibilityUtils.getMethod(TaskInputs.class, "property", String.class, Object.class);
    private static final Method taskOutputsDirMethod = CompatibilityUtils.getMethod(TaskOutputs.class, "dir", Object.class);
    @Nullable
    private static final Method taskInputPropertyBuilderOptionalMethod;
    private static final Method fileContentMergerGetBeforeMergedMethod;
    private static final Method fileContentMergerGetWhenMergedMethod;

    CompatibilityUtils() {
    }

    @Nullable
    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Method findMethod(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    static TaskInputs getInputs(Task task) {
        try {
            return (TaskInputs)taskGetInputsMethod.invoke((Object)task, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskOutputs getOutputs(Task task) {
        try {
            return (TaskOutputs)taskGetOutputsMethod.invoke((Object)task, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskInputs files(TaskInputs inputs, Object ... args) {
        try {
            return (TaskInputs)taskInputsFilesMethod.invoke((Object)inputs, new Object[]{args});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskInputs property(TaskInputs inputs, String name, Object value) {
        try {
            return (TaskInputs)taskInputsPropertyMethod.invoke((Object)inputs, name, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskInputs optionalProperty(TaskInputs inputs, String name, Object value) {
        inputs = CompatibilityUtils.property(inputs, name, value);
        if (taskInputPropertyBuilderOptionalMethod == null) {
            return inputs;
        }
        try {
            return (TaskInputs)taskInputPropertyBuilderOptionalMethod.invoke((Object)inputs, true);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void dir(TaskOutputs outputs, Object dir) {
        try {
            taskOutputsDirMethod.invoke((Object)outputs, dir);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Action<Object> getBeforeMerged(FileContentMerger merger) {
        try {
            return (Action)fileContentMergerGetBeforeMergedMethod.invoke((Object)merger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Action<Object> getWhenMerged(FileContentMerger merger) {
        try {
            return (Action)fileContentMergerGetWhenMergedMethod.invoke((Object)merger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Class<?> taskInputPropertyBuilderClass = CompatibilityUtils.classForName("org.gradle.api.tasks.TaskInputPropertyBuilder");
        taskInputPropertyBuilderOptionalMethod = taskInputPropertyBuilderClass == null ? null : CompatibilityUtils.getMethod(taskInputPropertyBuilderClass, "optional", Boolean.TYPE);
        fileContentMergerGetBeforeMergedMethod = CompatibilityUtils.getMethod(FileContentMerger.class, "getBeforeMerged", new Class[0]);
        fileContentMergerGetWhenMergedMethod = CompatibilityUtils.getMethod(FileContentMerger.class, "getWhenMerged", new Class[0]);
    }
}

