/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.ltgt.gradle.apt.CompatibilityUtils;
import net.ltgt.gradle.apt.EclipseFactorypath;
import net.ltgt.gradle.apt.Factorypath;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.tasks.Internal;
import org.gradle.plugins.ide.api.FileContentMerger;
import org.gradle.plugins.ide.api.XmlFileContentMerger;
import org.gradle.plugins.ide.api.XmlGeneratorTask;

public class GenerateEclipseFactorypath
extends XmlGeneratorTask<Factorypath> {
    private EclipseFactorypath factorypath = (EclipseFactorypath)this.getInstantiator().newInstance(EclipseFactorypath.class, new Object[]{new XmlFileContentMerger(this.getXmlTransformer())});

    public GenerateEclipseFactorypath() {
        this.getXmlTransformer().setIndentation("\t");
    }

    protected void configure(Factorypath factorypath) {
        EclipseFactorypath factorypathModel = this.getFactorypath();
        CompatibilityUtils.getBeforeMerged((FileContentMerger)factorypathModel.getFile()).execute((Object)factorypath);
        LinkedHashSet entries = new LinkedHashSet();
        for (Configuration configuration : factorypathModel.getPlusConfigurations()) {
            entries.addAll(configuration.getFiles());
        }
        for (Configuration configuration : factorypathModel.getMinusConfigurations()) {
            entries.removeAll(configuration.getFiles());
        }
        factorypath.setEntries(new ArrayList<File>(entries));
        CompatibilityUtils.getWhenMerged((FileContentMerger)factorypathModel.getFile()).execute((Object)factorypath);
    }

    @Internal
    public EclipseFactorypath getFactorypath() {
        return this.factorypath;
    }

    public void setFactorypath(EclipseFactorypath factorypath) {
        this.factorypath = factorypath;
    }

    protected Factorypath create() {
        return new Factorypath(this.getXmlTransformer());
    }
}

