/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.plugins.ide.api.FileContentMerger;

class CompatibilityUtils {
    private static final Method taskGetInputsMethod = CompatibilityUtils.getMethod(Task.class, "getInputs", new Class[0]);
    private static final Method taskGetOutputsMethod = CompatibilityUtils.getMethod(Task.class, "getOutputs", new Class[0]);
    private static final Method taskInputsFilesMethod = CompatibilityUtils.getMethod(TaskInputs.class, "files", Object[].class);
    private static final Method taskOutputsDirMethod = CompatibilityUtils.getMethod(TaskOutputs.class, "dir", Object.class);
    private static final Method taskPropertyBuilderWithPropertyNameMethod;
    private static final Method taskOutputFilePropertyBuilderOptionalMethod;
    private static final Method fileContentMergerGetBeforeMergedMethod;
    private static final Method fileContentMergerGetWhenMergedMethod;

    CompatibilityUtils() {
    }

    private static Class<?> classForName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Method getMethod(Class<?> klass, String methodName, Class<?> ... parameterTypes) {
        try {
            return klass.getMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskInputs getInputs(Task task) {
        try {
            return (TaskInputs)taskGetInputsMethod.invoke((Object)task, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskOutputs getOutputs(Task task) {
        try {
            return (TaskOutputs)taskGetOutputsMethod.invoke((Object)task, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskInputs files(TaskInputs inputs, Object ... args) {
        try {
            return (TaskInputs)taskInputsFilesMethod.invoke((Object)inputs, new Object[]{args});
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static TaskOutputs dir(TaskOutputs outputs, Object dir) {
        try {
            return (TaskOutputs)taskOutputsDirMethod.invoke((Object)outputs, dir);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void withPropertyName(Object taskPropertyBuilder, String propertyName) {
        if (taskPropertyBuilderWithPropertyNameMethod == null) {
            return;
        }
        try {
            taskPropertyBuilderWithPropertyNameMethod.invoke(taskPropertyBuilder, propertyName);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static void withPropertyName(TaskInputs inputs, String propertyName) {
        CompatibilityUtils.withPropertyName((Object)inputs, propertyName);
    }

    static void withPropertyName(TaskOutputs outputs, String propertyName) {
        CompatibilityUtils.withPropertyName((Object)outputs, propertyName);
    }

    static void optional(TaskOutputs outputs) {
        if (taskOutputFilePropertyBuilderOptionalMethod == null) {
            return;
        }
        try {
            taskOutputFilePropertyBuilderOptionalMethod.invoke((Object)outputs, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Action<Object> getBeforeMerged(FileContentMerger merger) {
        try {
            return (Action)fileContentMergerGetBeforeMergedMethod.invoke((Object)merger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static Action<Object> getWhenMerged(FileContentMerger merger) {
        try {
            return (Action)fileContentMergerGetWhenMergedMethod.invoke((Object)merger, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Class<?> taskPropertyBuilderClass = CompatibilityUtils.classForName("org.gradle.api.tasks.TaskPropertyBuilder");
        taskPropertyBuilderWithPropertyNameMethod = taskPropertyBuilderClass == null ? null : CompatibilityUtils.getMethod(taskPropertyBuilderClass, "withPropertyName", String.class);
        Class<?> taskOutputFilePropertyBuilderClass = CompatibilityUtils.classForName("org.gradle.api.tasks.TaskOutputFilePropertyBuilder");
        taskOutputFilePropertyBuilderOptionalMethod = taskOutputFilePropertyBuilderClass == null ? null : CompatibilityUtils.getMethod(taskOutputFilePropertyBuilderClass, "optional", new Class[0]);
        fileContentMergerGetBeforeMergedMethod = CompatibilityUtils.getMethod(FileContentMerger.class, "getBeforeMerged", new Class[0]);
        fileContentMergerGetWhenMergedMethod = CompatibilityUtils.getMethod(FileContentMerger.class, "getWhenMerged", new Class[0]);
    }
}

