/*
 * Decompiled with CFR 0.152.
 */
package net.ltgt.gradle.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import net.ltgt.gradle.apt.CompatibilityUtils;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.api.tasks.TaskOutputs;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.compile.JavaCompile;

public class AptPlugin
implements Plugin<Project> {
    public void apply(final Project project) {
        this.configureCompileTasks(project, JavaCompile.class, new GetCompileOptions<JavaCompile>(){

            @Override
            public CompileOptions getCompileOptions(JavaCompile task) {
                return task.getOptions();
            }
        });
        this.configureCompileTasks(project, GroovyCompile.class, new GetCompileOptions<GroovyCompile>(){

            @Override
            public CompileOptions getCompileOptions(GroovyCompile task) {
                return task.getOptions();
            }
        });
        project.getPlugins().withType(JavaBasePlugin.class, (Action)new Action<JavaBasePlugin>(){

            public void execute(JavaBasePlugin javaBasePlugin) {
                final JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                javaConvention.getSourceSets().all((Action)new Action<SourceSet>(){

                    public void execute(final SourceSet sourceSet) {
                        AptSourceSetConvention convention = new AptSourceSetConvention(project, sourceSet);
                        new DslObject((Object)sourceSet).getConvention().getPlugins().put("net.ltgt.apt", convention);
                        new DslObject((Object)sourceSet.getOutput()).getConvention().getPlugins().put("net.ltgt.apt", new AptSourceSetOutputConvention(project, sourceSet));
                        String compileOnlyConfigurationName = convention.getCompileOnlyConfigurationName();
                        Configuration configuration = (Configuration)project.getConfigurations().findByName(compileOnlyConfigurationName);
                        if (configuration == null) {
                            configuration = (Configuration)project.getConfigurations().create(compileOnlyConfigurationName);
                            configuration.setVisible(false);
                            configuration.setDescription("Compile-only classpath for ${sourceSet}.");
                            configuration.extendsFrom(new Configuration[]{(Configuration)project.getConfigurations().findByName(sourceSet.getCompileConfigurationName())});
                            sourceSet.setCompileClasspath((FileCollection)configuration);
                            if ("test".equals(sourceSet.getName())) {
                                final Configuration conf = configuration;
                                project.getPlugins().withType(JavaPlugin.class, (Action)new Action<JavaPlugin>(){

                                    public void execute(JavaPlugin javaPlugin) {
                                        sourceSet.setCompileClasspath((FileCollection)project.files(new Object[]{((SourceSet)javaConvention.getSourceSets().getByName("main")).getOutput(), conf}));
                                    }
                                });
                            }
                        }
                        Configuration aptConfiguration = (Configuration)project.getConfigurations().create(convention.getAptConfigurationName());
                        aptConfiguration.setVisible(false);
                        aptConfiguration.setDescription("Processor path for ${sourceSet}");
                        AptPlugin.this.configureCompileTask(project, sourceSet, sourceSet.getCompileJavaTaskName());
                    }
                });
            }
        });
        project.getPlugins().withType(GroovyBasePlugin.class, (Action)new Action<GroovyBasePlugin>(){

            public void execute(GroovyBasePlugin groovyBasePlugin) {
                JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
                javaConvention.getSourceSets().all((Action)new Action<SourceSet>(){

                    public void execute(SourceSet sourceSet) {
                        AptPlugin.this.configureCompileTask(project, sourceSet, sourceSet.getCompileTaskName("groovy"));
                    }
                });
            }
        });
    }

    private <T extends AbstractCompile> void configureCompileTasks(final Project project, Class<T> compileTaskClass, final GetCompileOptions<T> getCompileOptions) {
        project.getTasks().withType(compileTaskClass, new Action<T>(){

            public void execute(final T task) {
                task.getConvention().getPlugins().put("net.ltgt.apt", new AptConvention(project));
                CompatibilityUtils.getInputs(task).property("aptOptions.annotationProcessing", (Object)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((AptConvention)task.getConvention().getPlugin(AptConvention.class)).getAptOptions().isAnnotationProcessing();
                    }
                });
                CompatibilityUtils.getInputs(task).property("aptOptions.processors", (Object)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((AptConvention)task.getConvention().getPlugin(AptConvention.class)).getAptOptions().getProcessors();
                    }
                });
                CompatibilityUtils.getInputs(task).property("aptOptions.processorArgs", (Object)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((AptConvention)task.getConvention().getPlugin(AptConvention.class)).getAptOptions().getProcessorArgs();
                    }
                });
                TaskInputs inputs = CompatibilityUtils.files(CompatibilityUtils.getInputs(task), new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((AptConvention)task.getConvention().getPlugin(AptConvention.class)).getAptOptions().getProcessorpath();
                    }
                });
                CompatibilityUtils.withPropertyName(inputs, "aptOptions.processorpath");
                TaskOutputs outputs = CompatibilityUtils.dir(CompatibilityUtils.getOutputs(task), new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ((AptConvention)task.getConvention().getPlugin(AptConvention.class)).getGeneratedSourcesDestinationDir();
                    }
                });
                CompatibilityUtils.withPropertyName(outputs, "generatedSourcesDestinationDir");
                CompatibilityUtils.optional(outputs);
                task.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        AptConvention aptConvention = (AptConvention)task.getConvention().getPlugin(AptConvention.class);
                        aptConvention.makeDirectories();
                        getCompileOptions.getCompileOptions((AbstractCompile)task).getCompilerArgs().addAll(aptConvention.buildCompilerArgs());
                    }
                });
            }
        });
    }

    private void configureCompileTask(Project project, final SourceSet sourceSet, String taskName) {
        AbstractCompile task = (AbstractCompile)project.getTasks().withType(AbstractCompile.class).getByName(taskName);
        AptConvention aptConvention = (AptConvention)task.getConvention().getPlugin(AptConvention.class);
        aptConvention.setGeneratedSourcesDestinationDir(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((AptSourceSetOutputConvention)new DslObject((Object)sourceSet.getOutput()).getConvention().getPlugin(AptSourceSetOutputConvention.class)).getGeneratedSourcesDir();
            }
        });
        aptConvention.aptOptions.setProcessorpath(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ((AptSourceSetConvention)new DslObject((Object)sourceSet).getConvention().getPlugin(AptSourceSetConvention.class)).getProcessorpath();
            }
        });
    }

    public static class AptSourceSetOutputConvention {
        private final Project project;
        private Object generatedSourcesDir;

        public AptSourceSetOutputConvention(final Project project, final SourceSet sourceSet) {
            this.project = project;
            this.generatedSourcesDir = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return new File(project.getBuildDir(), "generated/source/apt/" + sourceSet.getName());
                }
            };
        }

        public File getGeneratedSourcesDir() {
            if (this.generatedSourcesDir == null) {
                return null;
            }
            return this.project.file(this.generatedSourcesDir);
        }

        public void setGeneratedSourcesDir(Object generatedSourcesDir) {
            this.generatedSourcesDir = generatedSourcesDir;
        }
    }

    public static class AptSourceSetConvention {
        private final Project project;
        private final SourceSet sourceSet;
        private Object processorpath;

        public AptSourceSetConvention(final Project project, SourceSet sourceSet) {
            this.project = project;
            this.sourceSet = sourceSet;
            this.processorpath = new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return project.getConfigurations().findByName(AptSourceSetConvention.this.getAptConfigurationName());
                }
            };
        }

        public FileCollection getProcessorpath() {
            if (this.processorpath == null) {
                return null;
            }
            return this.project.files(new Object[]{this.processorpath});
        }

        public void setProcessorpath(Object processorpath) {
            this.processorpath = processorpath;
        }

        public String getCompileOnlyConfigurationName() {
            return this.sourceSet.getCompileConfigurationName() + "Only";
        }

        public String getAptConfigurationName() {
            return this.sourceSet.getTaskName("", "apt");
        }
    }

    public static class AptOptions {
        private final Project project;
        private boolean annotationProcessing = true;
        private Object processorpath;
        private List<?> processors = new ArrayList();
        private Map<String, ?> processorArgs = new LinkedHashMap();

        public AptOptions(Project project) {
            this.project = project;
        }

        public boolean isAnnotationProcessing() {
            return this.annotationProcessing;
        }

        public void setAnnotationProcessing(boolean annotationProcessing) {
            this.annotationProcessing = annotationProcessing;
        }

        public FileCollection getProcessorpath() {
            if (this.processorpath == null) {
                return null;
            }
            return this.project.files(new Object[]{this.processorpath});
        }

        public void setProcessorpath(Object processorpath) {
            this.processorpath = processorpath;
        }

        public List<?> getProcessors() {
            return this.processors;
        }

        public void setProcessors(List<?> processors) {
            this.processors = processors;
        }

        public Map<String, ?> getProcessorArgs() {
            return this.processorArgs;
        }

        public void setProcessorArgs(Map<String, ?> processorArgs) {
            this.processorArgs = processorArgs;
        }
    }

    public static class AptConvention {
        private final Project project;
        private final AptOptions aptOptions;
        private Object generatedSourcesDestinationDir;

        public AptConvention(Project project) {
            this.project = project;
            this.aptOptions = new AptOptions(project);
        }

        public File getGeneratedSourcesDestinationDir() {
            if (this.generatedSourcesDestinationDir == null) {
                return null;
            }
            return this.project.file(this.generatedSourcesDestinationDir);
        }

        public void setGeneratedSourcesDestinationDir(Object generatedSourcesDestinationDir) {
            this.generatedSourcesDestinationDir = generatedSourcesDestinationDir;
        }

        public AptOptions getAptOptions() {
            return this.aptOptions;
        }

        void makeDirectories() {
            if (this.generatedSourcesDestinationDir != null) {
                this.project.mkdir(this.generatedSourcesDestinationDir);
            }
        }

        List<String> buildCompilerArgs() {
            ArrayList<String> result = new ArrayList<String>();
            if (this.generatedSourcesDestinationDir != null) {
                result.add("-s");
                result.add(this.getGeneratedSourcesDestinationDir().getPath());
            }
            if (!this.aptOptions.isAnnotationProcessing()) {
                result.add("-proc:none");
            }
            if (this.aptOptions.processorpath != null && !this.aptOptions.getProcessorpath().isEmpty()) {
                result.add("-processorpath");
                result.add(this.aptOptions.getProcessorpath().getAsPath());
            }
            if (this.aptOptions.processors != null && !this.aptOptions.getProcessors().isEmpty()) {
                result.add("-processor");
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object processor : this.aptOptions.getProcessors()) {
                    if (!first) {
                        sb.append(',');
                    } else {
                        first = false;
                    }
                    sb.append(processor);
                }
                result.add(sb.toString());
            }
            if (this.aptOptions.getProcessorArgs() != null) {
                for (Map.Entry<String, ?> entry : this.aptOptions.getProcessorArgs().entrySet()) {
                    result.add("-A" + entry.getKey() + "=" + entry.getValue());
                }
            }
            return result;
        }
    }

    private static interface GetCompileOptions<T extends AbstractCompile> {
        public CompileOptions getCompileOptions(T var1);
    }
}

