/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.util.JsonGeneratorDelegate;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.node.ArrayNode;

public class SimpleObjectJsonGeneratorDelegate
extends JsonGeneratorDelegate {
    public SimpleObjectJsonGeneratorDelegate(JsonGenerator delegate) {
        super(delegate, false);
    }

    public JsonGenerator writePOJO(Object value) {
        if (value == null) {
            this.writeNull();
            return this;
        }
        if (value instanceof String) {
            this.writeString((String)value);
            return this;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (n instanceof Integer) {
                this.writeNumber(n.intValue());
                return this;
            }
            if (n instanceof Long) {
                this.writeNumber(n.longValue());
                return this;
            }
            if (n instanceof Double) {
                this.writeNumber(n.doubleValue());
                return this;
            }
            if (n instanceof Float) {
                this.writeNumber(n.floatValue());
                return this;
            }
            if (n instanceof Short) {
                this.writeNumber(n.shortValue());
                return this;
            }
            if (n instanceof Byte) {
                this.writeNumber(n.byteValue());
                return this;
            }
            if (n instanceof BigInteger) {
                this.writeNumber((BigInteger)n);
                return this;
            }
            if (n instanceof BigDecimal) {
                this.writeNumber((BigDecimal)n);
                return this;
            }
            if (n instanceof AtomicInteger) {
                this.writeNumber(((AtomicInteger)n).get());
                return this;
            }
            if (n instanceof AtomicLong) {
                this.writeNumber(((AtomicLong)n).get());
                return this;
            }
        }
        if (value instanceof byte[]) {
            this.writeBinary((byte[])value);
            return this;
        }
        if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
            return this;
        }
        if (value instanceof AtomicBoolean) {
            this.writeBoolean(((AtomicBoolean)value).get());
            return this;
        }
        if (value instanceof JsonNode) {
            JsonNode node = (JsonNode)value;
            switch (node.getNodeType()) {
                case NULL: {
                    this.writeNull();
                    return this;
                }
                case STRING: {
                    this.writeString(node.asString());
                    return this;
                }
                case BOOLEAN: {
                    this.writeBoolean(node.asBoolean());
                    return this;
                }
                case BINARY: {
                    this.writeBinary(node.binaryValue());
                    return this;
                }
                case NUMBER: {
                    if (node.isInt()) {
                        this.writeNumber(node.intValue());
                        return this;
                    }
                    if (node.isLong()) {
                        this.writeNumber(node.longValue());
                        return this;
                    }
                    if (node.isShort()) {
                        this.writeNumber(node.shortValue());
                        return this;
                    }
                    if (node.isDouble()) {
                        this.writeNumber(node.doubleValue());
                        return this;
                    }
                    if (node.isFloat()) {
                        this.writeNumber(node.floatValue());
                        return this;
                    }
                    if (node.isBigDecimal()) {
                        this.writeNumber(node.decimalValue());
                        return this;
                    }
                    if (node.isBigInteger()) {
                        this.writeNumber(node.bigIntegerValue());
                        return this;
                    }
                }
                case OBJECT: {
                    this.writeStartObject(node);
                    for (Map.Entry entry : node.properties()) {
                        this.writePOJOProperty((String)entry.getKey(), entry.getValue());
                    }
                    this.writeEndObject();
                    return this;
                }
                case ARRAY: {
                    ArrayNode arrayNode = (ArrayNode)node;
                    int size = arrayNode.size();
                    this.writeStartArray(arrayNode, size);
                    for (JsonNode jsonNode : arrayNode.elements()) {
                        this.writePOJO(jsonNode);
                    }
                    this.writeEndArray();
                    return this;
                }
            }
        }
        this.delegate.writePOJO(value);
        return this;
    }
}

