/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.spi.ContextAware;
import com.fasterxml.jackson.databind.JsonNode;
import net.logstash.logback.composite.ContextJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.GlobalCustomFieldsJsonProvider;
import net.logstash.logback.composite.JsonProvider;
import net.logstash.logback.composite.JsonProviders;
import net.logstash.logback.composite.LogstashVersionJsonProvider;
import net.logstash.logback.composite.accessevent.AccessEventCompositeJsonFormatter;
import net.logstash.logback.composite.accessevent.AccessEventFormattedTimestampJsonProvider;
import net.logstash.logback.composite.accessevent.AccessEventJsonProviders;
import net.logstash.logback.composite.accessevent.AccessMessageJsonProvider;
import net.logstash.logback.composite.accessevent.ContentLengthJsonProvider;
import net.logstash.logback.composite.accessevent.ElapsedTimeJsonProvider;
import net.logstash.logback.composite.accessevent.HeaderFilter;
import net.logstash.logback.composite.accessevent.IncludeExcludeHeaderFilter;
import net.logstash.logback.composite.accessevent.MethodJsonProvider;
import net.logstash.logback.composite.accessevent.ProtocolJsonProvider;
import net.logstash.logback.composite.accessevent.RemoteHostJsonProvider;
import net.logstash.logback.composite.accessevent.RemoteUserJsonProvider;
import net.logstash.logback.composite.accessevent.RequestHeadersJsonProvider;
import net.logstash.logback.composite.accessevent.RequestedUriJsonProvider;
import net.logstash.logback.composite.accessevent.RequestedUrlJsonProvider;
import net.logstash.logback.composite.accessevent.ResponseHeadersJsonProvider;
import net.logstash.logback.composite.accessevent.StatusCodeJsonProvider;
import net.logstash.logback.fieldnames.LogstashAccessFieldNames;

public class LogstashAccessFormatter
extends AccessEventCompositeJsonFormatter {
    protected LogstashAccessFieldNames fieldNames = new LogstashAccessFieldNames();
    private final AccessEventFormattedTimestampJsonProvider timestampProvider = new AccessEventFormattedTimestampJsonProvider();
    private final LogstashVersionJsonProvider<IAccessEvent> versionProvider = new LogstashVersionJsonProvider();
    private final AccessMessageJsonProvider messageProvider = new AccessMessageJsonProvider();
    private final MethodJsonProvider methodProvider = new MethodJsonProvider();
    private final ProtocolJsonProvider protocolProvider = new ProtocolJsonProvider();
    private final StatusCodeJsonProvider statusCodeProvider = new StatusCodeJsonProvider();
    private final RequestedUrlJsonProvider requestedUrlProvider = new RequestedUrlJsonProvider();
    private final RequestedUriJsonProvider requestedUriProvider = new RequestedUriJsonProvider();
    private final RemoteHostJsonProvider remoteHostProvider = new RemoteHostJsonProvider();
    private final RemoteUserJsonProvider remoteUserProvider = new RemoteUserJsonProvider();
    private final ContentLengthJsonProvider contentLengthProvider = new ContentLengthJsonProvider();
    private final ElapsedTimeJsonProvider elapsedTimeProvider = new ElapsedTimeJsonProvider();
    private final RequestHeadersJsonProvider requestHeadersProvider = new RequestHeadersJsonProvider();
    private final ResponseHeadersJsonProvider responseHeadersProvider = new ResponseHeadersJsonProvider();
    private final ContextJsonProvider<IAccessEvent> contextProvider = new ContextJsonProvider();
    private GlobalCustomFieldsJsonProvider<IAccessEvent> globalCustomFieldsProvider;

    public LogstashAccessFormatter(ContextAware declaredOrigin) {
        super(declaredOrigin);
        this.getProviders().addTimestamp(this.timestampProvider);
        this.getProviders().addVersion(this.versionProvider);
        this.getProviders().addAccessMessage(this.messageProvider);
        this.getProviders().addMethod(this.methodProvider);
        this.getProviders().addProtocol(this.protocolProvider);
        this.getProviders().addStatusCode(this.statusCodeProvider);
        this.getProviders().addRequestedUrl(this.requestedUrlProvider);
        this.getProviders().addRequestedUri(this.requestedUriProvider);
        this.getProviders().addRemoteHost(this.remoteHostProvider);
        this.getProviders().addRemoteUser(this.remoteUserProvider);
        this.getProviders().addContentLength(this.contentLengthProvider);
        this.getProviders().addElapsedTime(this.elapsedTimeProvider);
        this.getProviders().addRequestHeaders(this.requestHeadersProvider);
        this.getProviders().addResponseHeaders(this.responseHeadersProvider);
        this.getProviders().addContext(this.contextProvider);
    }

    @Override
    public void start() {
        this.configureProviderFieldNames();
        super.start();
    }

    protected void configureProviderFieldNames() {
        for (JsonProvider provider : this.getProviders().getProviders()) {
            if (!(provider instanceof FieldNamesAware)) continue;
            ((FieldNamesAware)((Object)provider)).setFieldNames(this.fieldNames);
        }
    }

    public void addProvider(JsonProvider<IAccessEvent> provider) {
        this.getProviders().addProvider(provider);
    }

    public AccessEventJsonProviders getProviders() {
        return (AccessEventJsonProviders)super.getProviders();
    }

    public LogstashAccessFieldNames getFieldNames() {
        return this.fieldNames;
    }

    public void setFieldNames(LogstashAccessFieldNames fieldNames) {
        this.fieldNames = fieldNames;
    }

    public String getTimeZone() {
        return this.timestampProvider.getTimeZone();
    }

    public void setTimeZone(String timeZoneId) {
        this.timestampProvider.setTimeZone(timeZoneId);
        this.messageProvider.setTimeZone(timeZoneId);
    }

    public String getTimestampPattern() {
        return this.timestampProvider.getPattern();
    }

    public void setTimestampPattern(String pattern) {
        this.timestampProvider.setPattern(pattern);
    }

    public String getCustomFieldsAsString() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFields();
    }

    public void setCustomFieldsFromString(String customFields) {
        if (customFields == null || customFields.length() == 0) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider<IAccessEvent>();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFields(customFields);
        }
    }

    public void setCustomFields(JsonNode customFields) {
        if (customFields == null) {
            this.getProviders().removeProvider(this.globalCustomFieldsProvider);
            this.globalCustomFieldsProvider = null;
        } else {
            if (this.globalCustomFieldsProvider == null) {
                this.globalCustomFieldsProvider = new GlobalCustomFieldsJsonProvider<IAccessEvent>();
                this.getProviders().addGlobalCustomFields(this.globalCustomFieldsProvider);
            }
            this.globalCustomFieldsProvider.setCustomFieldsNode(customFields);
        }
    }

    public JsonNode getCustomFields() {
        return this.globalCustomFieldsProvider == null ? null : this.globalCustomFieldsProvider.getCustomFieldsNode();
    }

    public boolean getLowerCaseHeaderNames() {
        return this.requestHeadersProvider.getLowerCaseHeaderNames();
    }

    public void setLowerCaseHeaderNames(boolean lowerCaseHeaderNames) {
        this.requestHeadersProvider.setLowerCaseHeaderNames(lowerCaseHeaderNames);
        this.responseHeadersProvider.setLowerCaseHeaderNames(lowerCaseHeaderNames);
    }

    public HeaderFilter getRequestHeaderFilter() {
        return this.requestHeadersProvider.getFilter();
    }

    @DefaultClass(value=IncludeExcludeHeaderFilter.class)
    public void setRequestHeaderFilter(HeaderFilter filter) {
        this.requestHeadersProvider.setFilter(filter);
    }

    public HeaderFilter getResponseHeaderFilter() {
        return this.responseHeadersProvider.getFilter();
    }

    @DefaultClass(value=IncludeExcludeHeaderFilter.class)
    public void setResponseHeaderFilter(HeaderFilter filter) {
        this.responseHeadersProvider.setFilter(filter);
    }

    public String getVersion() {
        return this.versionProvider.getVersion();
    }

    public void setVersion(String version) {
        this.versionProvider.setVersion(version);
    }

    @Deprecated
    public boolean isWriteVersionAsString() {
        return this.versionProvider.isWriteAsString();
    }

    @Deprecated
    public void setWriteVersionAsString(boolean writeVersionAsString) {
        this.versionProvider.setWriteAsString(writeVersionAsString);
    }

    public boolean isWriteVersionAsInteger() {
        return this.versionProvider.isWriteAsInteger();
    }

    public void setWriteVersionAsInteger(boolean writeVersionAsInteger) {
        this.versionProvider.setWriteAsInteger(writeVersionAsInteger);
    }

    @Override
    public void setProviders(JsonProviders<IAccessEvent> jsonProviders) {
        if (super.getProviders() != null && !super.getProviders().getProviders().isEmpty()) {
            this.addError("Unable to set providers when using predefined composites.");
        } else {
            super.setProviders(jsonProviders);
        }
    }
}

