/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std;

import java.io.IOException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonParser;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonProcessingException;
import net.logstash.logback.encoder.com.fasterxml.jackson.core.JsonToken;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationContext;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;

public abstract class FromStringDeserializer<T>
extends StdScalarDeserializer<T> {
    private static final long serialVersionUID = 1L;

    protected FromStringDeserializer(Class<?> clazz) {
        super(clazz);
    }

    @Override
    public final T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        String string = jsonParser.getValueAsString();
        if (string != null) {
            if (string.length() == 0 || (string = string.trim()).length() == 0) {
                return null;
            }
            try {
                T t = this._deserialize(string, deserializationContext);
                if (t != null) {
                    return t;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw deserializationContext.weirdStringException(string, this._valueClass, "not a valid textual representation");
        }
        if (jsonParser.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (this._valueClass.isAssignableFrom(object.getClass())) {
                return (T)object;
            }
            return this._deserializeEmbedded(object, deserializationContext);
        }
        throw deserializationContext.mappingException(this._valueClass);
    }

    protected abstract T _deserialize(String var1, DeserializationContext var2) throws IOException, JsonProcessingException;

    protected T _deserializeEmbedded(Object object, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        throw deserializationContext.mappingException("Don't know how to convert embedded Object of type " + object.getClass().getName() + " into " + this._valueClass.getName());
    }
}

