/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.impl;

import java.lang.reflect.Member;
import java.util.HashMap;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.BeanDescription;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.DeserializationConfig;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.JavaType;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.CreatorProperty;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.ValueInstantiator;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.type.TypeBindings;
import net.logstash.logback.encoder.com.fasterxml.jackson.databind.util.ClassUtil;

public class CreatorCollector {
    protected final BeanDescription _beanDesc;
    protected final boolean _canFixAccess;
    protected AnnotatedWithParams _defaultConstructor;
    protected AnnotatedWithParams _stringCreator;
    protected AnnotatedWithParams _intCreator;
    protected AnnotatedWithParams _longCreator;
    protected AnnotatedWithParams _doubleCreator;
    protected AnnotatedWithParams _booleanCreator;
    protected AnnotatedWithParams _delegateCreator;
    protected CreatorProperty[] _delegateArgs;
    protected AnnotatedWithParams _propertyBasedCreator;
    protected CreatorProperty[] _propertyBasedArgs = null;
    protected AnnotatedParameter _incompleteParameter;

    public CreatorCollector(BeanDescription beanDescription, boolean bl) {
        this._beanDesc = beanDescription;
        this._canFixAccess = bl;
    }

    public ValueInstantiator constructValueInstantiator(DeserializationConfig deserializationConfig) {
        JavaType javaType;
        StdValueInstantiator stdValueInstantiator = new StdValueInstantiator(deserializationConfig, this._beanDesc.getType());
        if (this._delegateCreator == null) {
            javaType = null;
        } else {
            int n = 0;
            if (this._delegateArgs != null) {
                int n2 = this._delegateArgs.length;
                for (int i = 0; i < n2; ++i) {
                    if (this._delegateArgs[i] != null) continue;
                    n = i;
                    break;
                }
            }
            TypeBindings typeBindings = this._beanDesc.bindingsForBeanType();
            javaType = typeBindings.resolveType(this._delegateCreator.getGenericParameterType(n));
        }
        stdValueInstantiator.configureFromObjectSettings(this._defaultConstructor, this._delegateCreator, javaType, this._delegateArgs, this._propertyBasedCreator, this._propertyBasedArgs);
        stdValueInstantiator.configureFromStringCreator(this._stringCreator);
        stdValueInstantiator.configureFromIntCreator(this._intCreator);
        stdValueInstantiator.configureFromLongCreator(this._longCreator);
        stdValueInstantiator.configureFromDoubleCreator(this._doubleCreator);
        stdValueInstantiator.configureFromBooleanCreator(this._booleanCreator);
        stdValueInstantiator.configureIncompleteParameter(this._incompleteParameter);
        return stdValueInstantiator;
    }

    public void setDefaultCreator(AnnotatedWithParams annotatedWithParams) {
        this._defaultConstructor = this._fixAccess(annotatedWithParams);
    }

    public void addStringCreator(AnnotatedWithParams annotatedWithParams) {
        this._stringCreator = this.verifyNonDup(annotatedWithParams, this._stringCreator, "String");
    }

    public void addIntCreator(AnnotatedWithParams annotatedWithParams) {
        this._intCreator = this.verifyNonDup(annotatedWithParams, this._intCreator, "int");
    }

    public void addLongCreator(AnnotatedWithParams annotatedWithParams) {
        this._longCreator = this.verifyNonDup(annotatedWithParams, this._longCreator, "long");
    }

    public void addDoubleCreator(AnnotatedWithParams annotatedWithParams) {
        this._doubleCreator = this.verifyNonDup(annotatedWithParams, this._doubleCreator, "double");
    }

    public void addBooleanCreator(AnnotatedWithParams annotatedWithParams) {
        this._booleanCreator = this.verifyNonDup(annotatedWithParams, this._booleanCreator, "boolean");
    }

    public void addDelegatingCreator(AnnotatedWithParams annotatedWithParams, CreatorProperty[] creatorPropertyArray) {
        this._delegateCreator = this.verifyNonDup(annotatedWithParams, this._delegateCreator, "delegate");
        this._delegateArgs = creatorPropertyArray;
    }

    public void addPropertyCreator(AnnotatedWithParams annotatedWithParams, CreatorProperty[] creatorPropertyArray) {
        this._propertyBasedCreator = this.verifyNonDup(annotatedWithParams, this._propertyBasedCreator, "property-based");
        if (creatorPropertyArray.length > 1) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            int n = creatorPropertyArray.length;
            for (int i = 0; i < n; ++i) {
                Integer n2;
                String string = creatorPropertyArray[i].getName();
                if (string.length() == 0 && creatorPropertyArray[i].getInjectableValueId() != null || (n2 = hashMap.put(string, i)) == null) continue;
                throw new IllegalArgumentException("Duplicate creator property \"" + string + "\" (index " + n2 + " vs " + i + ")");
            }
        }
        this._propertyBasedArgs = creatorPropertyArray;
    }

    public void addIncompeteParameter(AnnotatedParameter annotatedParameter) {
        if (this._incompleteParameter == null) {
            this._incompleteParameter = annotatedParameter;
        }
    }

    public boolean hasDefaultCreator() {
        return this._defaultConstructor != null;
    }

    private <T extends AnnotatedMember> T _fixAccess(T t) {
        if (t != null && this._canFixAccess) {
            ClassUtil.checkAndFixAccess((Member)((Object)t.getAnnotated()));
        }
        return t;
    }

    protected AnnotatedWithParams verifyNonDup(AnnotatedWithParams annotatedWithParams, AnnotatedWithParams annotatedWithParams2, String string) {
        if (annotatedWithParams2 != null && annotatedWithParams2.getClass() == annotatedWithParams.getClass()) {
            throw new IllegalArgumentException("Conflicting " + string + " creators: already had " + annotatedWithParams2 + ", encountered " + annotatedWithParams);
        }
        return this._fixAccess(annotatedWithParams);
    }
}

