/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.encoder.EncoderBase;
import java.io.IOException;
import java.io.OutputStream;
import net.logstash.logback.LogstashFormatter;
import org.apache.commons.io.IOUtils;

public class LogstashEncoder
extends EncoderBase<ILoggingEvent> {
    private boolean immediateFlush = true;
    private final LogstashFormatter formatter = new LogstashFormatter();

    public void doEncode(ILoggingEvent event) throws IOException {
        IOUtils.write((byte[])this.formatter.writeValueAsBytes(event, this.getContext()), (OutputStream)this.outputStream);
        IOUtils.write((String)CoreConstants.LINE_SEPARATOR, (OutputStream)this.outputStream);
        if (this.immediateFlush) {
            this.outputStream.flush();
        }
    }

    public void close() throws IOException {
        IOUtils.write((String)IOUtils.LINE_SEPARATOR, (OutputStream)this.outputStream);
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public boolean isIncludeCallerInfo() {
        return this.formatter.isIncludeCallerInfo();
    }

    public void setIncludeCallerInfo(boolean includeCallerInfo) {
        this.formatter.setIncludeCallerInfo(includeCallerInfo);
    }
}

