/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import net.logicsquad.nanocaptcha.image.renderer.AbstractWordRenderer;

public final class DefaultWordRenderer
extends AbstractWordRenderer {
    private DefaultWordRenderer(double xOffset, double yOffset, Supplier<Color> colorSupplier, Supplier<Font> fontSupplier) {
        super(xOffset, yOffset, colorSupplier, fontSupplier);
    }

    @Override
    public void render(String word, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g.setRenderingHints(hints);
        FontRenderContext frc = g.getFontRenderContext();
        int xBaseline = (int)Math.round((double)image.getWidth() * this.xOffset());
        int yBaseline = image.getHeight() - (int)Math.round((double)image.getHeight() * this.yOffset());
        char[] chars = new char[1];
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c;
            chars[0] = c = cArray[i];
            g.setColor(this.colorSupplier().get());
            Font font = this.fontSupplier().get();
            g.setFont(font);
            GlyphVector gv = font.createGlyphVector(frc, chars);
            g.drawChars(chars, 0, chars.length, xBaseline, yBaseline);
            int width = (int)gv.getVisualBounds().getWidth();
            xBaseline += width;
        }
    }

    public static class Builder
    extends AbstractWordRenderer.Builder {
        @Override
        public DefaultWordRenderer build() {
            return new DefaultWordRenderer(this.xOffset, this.yOffset, this.colorSupplier, this.fontSupplier);
        }
    }
}

