/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.logicsquad.nanocaptcha.image.renderer.DefaultWordRenderer;
import net.logicsquad.nanocaptcha.image.renderer.WordRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWordRenderer
implements WordRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWordRenderer.class);
    private static final String COURIER_PRIME_FONT = "/fonts/CourierPrime-Bold.ttf";
    private static final String PUBLIC_SANS_FONT = "/fonts/PublicSans-Bold.ttf";
    protected static final Random RAND = new Random();
    protected static final List<Color> DEFAULT_COLORS;
    protected static final List<Font> DEFAULT_FONTS;
    protected static final Supplier<Color> DEFAULT_COLOR_SUPPLIER;
    protected static final Supplier<Font> DEFAULT_FONT_SUPPLIER;
    protected static final int FONT_SIZE = 40;
    protected static final double X_OFFSET_DEFAULT = 0.05;
    protected static final double Y_OFFSET_DEFAULT = 0.25;
    private static final double Y_OFFSET_MIN = 0.0;
    private static final double Y_OFFSET_MAX = 0.75;
    private final double xOffset;
    private final double yOffset;
    private final Supplier<Color> colorSupplier;
    private final Supplier<Font> fontSupplier;

    protected AbstractWordRenderer(double xOffset, double yOffset, Supplier<Color> colorSupplier, Supplier<Font> fontSupplier) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.colorSupplier = colorSupplier;
        this.fontSupplier = fontSupplier;
    }

    @Override
    public abstract void render(String var1, BufferedImage var2);

    protected double xOffset() {
        return this.xOffset;
    }

    protected double yOffset() {
        return this.yOffset;
    }

    protected Supplier<Color> colorSupplier() {
        return this.colorSupplier;
    }

    protected Supplier<Font> fontSupplier() {
        return this.fontSupplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Font fontFromResource(String resourceName) {
        try (InputStream is = DefaultWordRenderer.class.getResourceAsStream(resourceName);){
            Font font = Font.createFont(0, is).deriveFont(40.0f);
            return font;
        }
        catch (FontFormatException | IOException e) {
            LOG.error("Unable to load font '{}'.", (Object)resourceName, (Object)e);
            return null;
        }
    }

    static {
        List<Color> defaultColors = Arrays.asList(Color.BLACK);
        DEFAULT_COLORS = Collections.unmodifiableList(defaultColors);
        List<Font> defaultFonts = Arrays.asList(AbstractWordRenderer.fontFromResource(COURIER_PRIME_FONT), AbstractWordRenderer.fontFromResource(PUBLIC_SANS_FONT));
        DEFAULT_FONTS = Collections.unmodifiableList(defaultFonts);
        DEFAULT_COLOR_SUPPLIER = () -> DEFAULT_COLORS.get(RAND.nextInt(DEFAULT_COLORS.size()));
        DEFAULT_FONT_SUPPLIER = () -> DEFAULT_FONTS.get(RAND.nextInt(DEFAULT_FONTS.size()));
    }

    public static abstract class Builder
    implements net.logicsquad.nanocaptcha.Builder<AbstractWordRenderer> {
        protected double xOffset = 0.05;
        protected double yOffset = 0.25;
        protected Supplier<Color> colorSupplier = DEFAULT_COLOR_SUPPLIER;
        protected Supplier<Font> fontSupplier = DEFAULT_FONT_SUPPLIER;

        protected Builder() {
        }

        public Builder yOffset(double yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public Builder xOffset(double xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder randomiseYOffset() {
            this.yOffset = 0.0 + 0.75 * RAND.nextDouble();
            return this;
        }

        public Builder randomColor(Color color, Color ... colors) {
            ArrayList<Color> colorList = new ArrayList<Color>();
            colorList.add(color);
            Collections.addAll(colorList, colors);
            return this.randomColor(colorList);
        }

        public Builder randomColor(List<Color> colors) {
            if (!colors.isEmpty()) {
                this.colorSupplier = () -> (Color)colors.get(RAND.nextInt(colors.size()));
            }
            return this;
        }

        public Builder color(Color color) {
            this.colorSupplier = () -> color;
            return this;
        }

        public Builder randomFont(Font font, Font ... fonts) {
            ArrayList<Font> fontList = new ArrayList<Font>();
            fontList.add(font);
            Collections.addAll(fontList, fonts);
            return this.randomFont(fontList);
        }

        public Builder randomFont(List<Font> fonts) {
            if (!fonts.isEmpty()) {
                this.fontSupplier = () -> (Font)fonts.get(RAND.nextInt(fonts.size()));
            }
            return this;
        }

        public Builder font(Font font) {
            this.fontSupplier = () -> font;
            return this;
        }
    }
}

