/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.noise;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.logicsquad.nanocaptcha.image.noise.NoiseProducer;

public class SaltAndPepperNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new Random();
    private static final double DEFAULT_NOISE_DENSITY = 0.15;
    private static final int PEPPER = Color.BLACK.getRGB();
    private static final int SALT = Color.WHITE.getRGB();
    private final double noiseDensity;

    public SaltAndPepperNoiseProducer() {
        this(0.15);
    }

    public SaltAndPepperNoiseProducer(double noiseDensity) {
        if (noiseDensity < 0.0 || noiseDensity > 1.0) {
            throw new IllegalArgumentException("Noise density must be between 0 and 1.");
        }
        this.noiseDensity = noiseDensity;
    }

    @Override
    public void makeNoise(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (!(RAND.nextDouble() < this.noiseDensity)) continue;
                int color = RAND.nextBoolean() ? PEPPER : SALT;
                image.setRGB(x, y, color);
            }
        }
    }
}

