/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.noise;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Random;
import net.logicsquad.nanocaptcha.image.noise.NoiseProducer;

public class GaussianNoiseProducer
implements NoiseProducer {
    private static final Random RAND = new Random();
    private static final int DEFAULT_STANDARD_DEVIATION = 20;
    private static final int DEFAULT_MEAN = 0;
    private final int standardDeviation;
    private final int mean;

    public GaussianNoiseProducer() {
        this(20, 0);
    }

    public GaussianNoiseProducer(int standardDeviation, int mean) {
        this.standardDeviation = standardDeviation;
        this.mean = mean;
    }

    @Override
    public void makeNoise(BufferedImage image) {
        WritableRaster raster = image.getRaster();
        for (int y = 0; y < raster.getHeight(); ++y) {
            for (int x = 0; x < raster.getWidth(); ++x) {
                int[] pixelSamples = raster.getPixel(x, y, (int[])null);
                for (int i = 0; i < pixelSamples.length; ++i) {
                    pixelSamples[i] = GaussianNoiseProducer.clamp((int)((double)pixelSamples[i] + RAND.nextGaussian() * (double)this.standardDeviation + (double)this.mean), 0, 255);
                }
                raster.setPixel(x, y, pixelSamples);
            }
        }
    }

    private static int clamp(int x, int a, int b) {
        return x < a ? a : (x > b ? b : x);
    }
}

