/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.audio.producer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.logicsquad.nanocaptcha.audio.Sample;
import net.logicsquad.nanocaptcha.audio.producer.VoiceProducer;

public class RandomNumberVoiceProducer
implements VoiceProducer {
    private static final Random RAND = new Random();
    private static final List<Locale> SUPPORTED_LANGUAGES = Arrays.asList(Locale.ENGLISH, Locale.GERMAN);
    static final String DEFAULT_LANGUAGE_KEY = "net.logicsquad.nanocaptcha.audio.producer.RandomNumberVoiceProducer.defaultLanguage";
    private static final Locale FALLBACK_LANGUAGE = Locale.ENGLISH;
    private static final String PATH_PREFIX_TEMPLATE = "/sounds/%s/numbers/";
    private static final List<String> VOICES_EN = Arrays.asList("a", "b", "c", "d", "e", "f", "g");
    private static final List<String> VOICES_DE = Arrays.asList("a", "b");
    private static final Map<Locale, List<String>> VOICES = new HashMap<Locale, List<String>>();
    static volatile Locale defaultLanguage;
    private Map<Integer, List<String>> vocalizations;
    final Locale language;
    private String pathPrefix;

    public RandomNumberVoiceProducer() {
        this(RandomNumberVoiceProducer.defaultLanguage());
    }

    public RandomNumberVoiceProducer(Locale language) {
        Objects.requireNonNull(language);
        this.language = SUPPORTED_LANGUAGES.contains(language) ? language : RandomNumberVoiceProducer.defaultLanguage();
    }

    @Override
    public final Sample getVocalization(char number) {
        String stringNumber = Character.toString(number);
        try {
            int idx = Integer.parseInt(stringNumber);
            List<String> files = this.vocalizations().get(idx);
            String filename = files.get(RAND.nextInt(files.size()));
            return new Sample(filename);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("RandomNumberVoiceProducer can only vocalize numbers.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Locale defaultLanguage() {
        if (defaultLanguage != null) return defaultLanguage;
        Class<RandomNumberVoiceProducer> clazz = RandomNumberVoiceProducer.class;
        synchronized (RandomNumberVoiceProducer.class) {
            if (defaultLanguage != null) return defaultLanguage;
            String language = System.getProperty(DEFAULT_LANGUAGE_KEY);
            defaultLanguage = language == null || !SUPPORTED_LANGUAGES.stream().map(l -> l.getLanguage()).anyMatch(s -> s.equals(language)) ? FALLBACK_LANGUAGE : new Locale(language);
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultLanguage;
        }
    }

    private String pathPrefix() {
        if (this.pathPrefix == null) {
            this.pathPrefix = String.format(PATH_PREFIX_TEMPLATE, this.language.getLanguage());
        }
        return this.pathPrefix;
    }

    private Map<Integer, List<String>> vocalizations() {
        if (this.vocalizations == null) {
            this.vocalizations = new HashMap<Integer, List<String>>();
            for (int i = 0; i < 10; ++i) {
                ArrayList<String> sampleNames = new ArrayList<String>();
                for (String name : VOICES.get(this.language)) {
                    StringBuilder sb = new StringBuilder(this.pathPrefix());
                    sb.append(i).append("_").append(name).append(".wav");
                    sampleNames.add(sb.toString());
                }
                this.vocalizations.put(i, sampleNames);
            }
        }
        return this.vocalizations;
    }

    static {
        VOICES.put(Locale.ENGLISH, VOICES_EN);
        VOICES.put(Locale.GERMAN, VOICES_DE);
    }
}

