/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.time.OffsetDateTime;
import net.logicsquad.nanocaptcha.content.ContentProducer;
import net.logicsquad.nanocaptcha.content.LatinContentProducer;
import net.logicsquad.nanocaptcha.image.backgrounds.BackgroundProducer;
import net.logicsquad.nanocaptcha.image.backgrounds.TransparentBackgroundProducer;
import net.logicsquad.nanocaptcha.image.filter.ImageFilter;
import net.logicsquad.nanocaptcha.image.filter.RippleImageFilter;
import net.logicsquad.nanocaptcha.image.noise.CurvedLineNoiseProducer;
import net.logicsquad.nanocaptcha.image.noise.NoiseProducer;
import net.logicsquad.nanocaptcha.image.renderer.DefaultWordRenderer;
import net.logicsquad.nanocaptcha.image.renderer.WordRenderer;

public final class ImageCaptcha {
    private static final String DEFAULT_X_KEY = "net.logicsquad.nanocaptcha.image.ImageCaptcha.defaultX";
    private static final String DEFAULT_Y_KEY = "net.logicsquad.nanocaptcha.image.ImageCaptcha.defaultY";
    private static final int DEFAULT_X = 200;
    private static final int DEFAULT_Y = 50;
    private final BufferedImage image;
    private final String content;
    private final OffsetDateTime created;

    private ImageCaptcha(Builder builder) {
        this.image = builder.image;
        this.content = builder.content;
        this.created = OffsetDateTime.now();
    }

    public static ImageCaptcha create() {
        return new Builder(Integer.getInteger(DEFAULT_X_KEY, 200), Integer.getInteger(DEFAULT_Y_KEY, 50)).addContent().build();
    }

    public boolean isCorrect(String answer) {
        if (answer == null) {
            return false;
        }
        return answer.equals(this.content);
    }

    public String getContent() {
        return this.content;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(35);
        sb.append("[ImageCaptcha: created=").append(this.created).append(" content='").append(this.content).append("']");
        return sb.toString();
    }

    public static class Builder
    implements net.logicsquad.nanocaptcha.Builder<ImageCaptcha> {
        private String content = "";
        private BufferedImage image;
        private BufferedImage background;
        private boolean addBorder;

        public Builder(int width, int height) {
            this.image = new BufferedImage(width, height, 2);
        }

        public Builder addBackground() {
            return this.addBackground(new TransparentBackgroundProducer());
        }

        public Builder addBackground(BackgroundProducer backgroundProducer) {
            this.background = backgroundProducer.getBackground(this.image.getWidth(), this.image.getHeight());
            return this;
        }

        public Builder addContent() {
            return this.addContent(new LatinContentProducer());
        }

        public Builder addContent(int length) {
            return this.addContent(new LatinContentProducer(length));
        }

        public Builder addContent(ContentProducer contentProducer) {
            return this.addContent(contentProducer, new DefaultWordRenderer.Builder().build());
        }

        public Builder addContent(ContentProducer contentProducer, WordRenderer wordRenderer) {
            this.content = this.content + contentProducer.getContent();
            wordRenderer.render(this.content, this.image);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new CurvedLineNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noiseProducer) {
            noiseProducer.makeNoise(this.image);
            return this;
        }

        public Builder addFilter() {
            return this.addFilter(new RippleImageFilter());
        }

        public Builder addFilter(ImageFilter filter) {
            filter.filter(this.image);
            return this;
        }

        public Builder addBorder() {
            this.addBorder = true;
            return this;
        }

        @Override
        public ImageCaptcha build() {
            Graphics2D g;
            if (this.background != null) {
                g = this.background.createGraphics();
                g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                g.drawImage(this.image, null, null);
                this.image = this.background;
            }
            if (this.addBorder) {
                g = this.image.createGraphics();
                int width = this.image.getWidth();
                int height = this.image.getHeight();
                g.setColor(Color.BLACK);
                g.drawLine(0, 0, 0, width);
                g.drawLine(0, 0, width, 0);
                g.drawLine(0, height - 1, width, height - 1);
                g.drawLine(width - 1, height - 1, width - 1, 0);
            }
            return new ImageCaptcha(this);
        }
    }
}

