/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.logicsquad.nanocaptcha.image.renderer.DefaultWordRenderer;
import net.logicsquad.nanocaptcha.image.renderer.WordRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWordRenderer
implements WordRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWordRenderer.class);
    private static final String COURIER_PRIME_FONT = "/fonts/CourierPrime-Bold.ttf";
    private static final String PUBLIC_SANS_FONT = "/fonts/PublicSans-Bold.ttf";
    protected static final List<Color> DEFAULT_COLORS = new ArrayList<Color>();
    protected static final List<Font> DEFAULT_FONTS = new ArrayList<Font>();
    protected static final int FONT_SIZE = 40;
    protected static final Random RAND;
    protected static final double X_OFFSET_DEFAULT = 0.05;
    protected static final double Y_OFFSET_DEFAULT = 0.25;
    private static final double Y_OFFSET_MIN = 0.0;
    private static final double Y_OFFSET_MAX = 0.75;
    private final double xOffset;
    private final double yOffset;

    protected AbstractWordRenderer() {
        this.xOffset = 0.05;
        this.yOffset = 0.25;
    }

    protected AbstractWordRenderer(double xOffset, double yOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
    }

    @Override
    public abstract void render(String var1, BufferedImage var2);

    protected double xOffset() {
        return this.xOffset;
    }

    protected double yOffset() {
        return this.yOffset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Font fontFromResource(String resourceName) {
        try (InputStream is = DefaultWordRenderer.class.getResourceAsStream(resourceName);){
            Font font = Font.createFont(0, is).deriveFont(40.0f);
            return font;
        }
        catch (FontFormatException | IOException e) {
            LOG.error("Unable to load font '{}'.", (Object)resourceName, (Object)e);
            return null;
        }
    }

    static {
        DEFAULT_COLORS.add(Color.BLACK);
        DEFAULT_FONTS.add(AbstractWordRenderer.fontFromResource(COURIER_PRIME_FONT));
        DEFAULT_FONTS.add(AbstractWordRenderer.fontFromResource(PUBLIC_SANS_FONT));
        RAND = new Random();
    }

    public static abstract class Builder
    implements net.logicsquad.nanocaptcha.Builder<AbstractWordRenderer> {
        protected double xOffset = 0.05;
        protected double yOffset = 0.25;

        protected Builder() {
        }

        public Builder setYOffset(double yOffset) {
            this.yOffset = yOffset;
            return this;
        }

        public Builder setXOffset(double xOffset) {
            this.xOffset = xOffset;
            return this;
        }

        public Builder randomiseYOffset() {
            this.yOffset = 0.0 + 0.75 * RAND.nextDouble();
            return this;
        }
    }
}

