/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.filter;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;
import net.logicsquad.nanocaptcha.image.filter.ImageFilter;

public class ShearImageFilter
implements ImageFilter {
    private static final double TWO_PI = Math.PI * 2;
    private static final Color DEFAULT_COLOR = Color.GRAY;
    private static final Random RAND = new Random();
    private final Color color;

    public ShearImageFilter() {
        this(DEFAULT_COLOR);
    }

    public ShearImageFilter(Color color) {
        this.color = color;
    }

    @Override
    public void filter(BufferedImage bi) {
        Graphics2D g = bi.createGraphics();
        this.shearX(g, bi.getWidth(), bi.getHeight());
        this.shearY(g, bi.getWidth(), bi.getHeight());
        g.dispose();
    }

    private void shearX(Graphics2D g, int w1, int h1) {
        int period = RAND.nextInt(10) + 5;
        boolean borderGap = true;
        int frames = 15;
        int phase = RAND.nextInt(5) + 2;
        for (int i = 0; i < h1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)i / (double)period + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(0, i, w1, 1, (int)d, 0);
            if (!borderGap) continue;
            g.setColor(this.color);
            g.drawLine((int)d, i, 0, i);
            g.drawLine((int)d + w1, i, w1, i);
        }
    }

    private void shearY(Graphics2D g, int w1, int h1) {
        int period = RAND.nextInt(30) + 10;
        boolean borderGap = true;
        int frames = 15;
        int phase = 7;
        for (int i = 0; i < w1; ++i) {
            double d = (double)(period >> 1) * Math.sin((double)((float)i / (float)period) + Math.PI * 2 * (double)phase / (double)frames);
            g.copyArea(i, 0, 1, h1, 0, (int)d);
            if (!borderGap) continue;
            g.setColor(this.color);
            g.drawLine(i, (int)d, i, 0);
            g.drawLine(i, (int)d + h1, i, h1);
        }
    }
}

