/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.audio;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.logicsquad.nanocaptcha.audio.Mixer;
import net.logicsquad.nanocaptcha.audio.Sample;
import net.logicsquad.nanocaptcha.audio.noise.NoiseProducer;
import net.logicsquad.nanocaptcha.audio.noise.RandomNoiseProducer;
import net.logicsquad.nanocaptcha.audio.producer.RandomNumberVoiceProducer;
import net.logicsquad.nanocaptcha.audio.producer.VoiceProducer;
import net.logicsquad.nanocaptcha.content.ContentProducer;
import net.logicsquad.nanocaptcha.content.NumbersContentProducer;

public final class AudioCaptcha {
    private final Sample audio;
    private final String content;
    private final OffsetDateTime created;

    private AudioCaptcha(Builder builder) {
        this.audio = builder.audio;
        this.content = builder.content;
        this.created = OffsetDateTime.now();
    }

    public boolean isCorrect(String answer) {
        return answer.equals(this.content);
    }

    public String getContent() {
        return this.content;
    }

    public Sample getAudio() {
        return this.audio;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(35);
        sb.append("[AudioCaptcha: created=").append(this.created).append(" content='").append(this.content).append("']");
        return sb.toString();
    }

    public OffsetDateTime getCreated() {
        return this.created;
    }

    public static class Builder
    implements net.logicsquad.nanocaptcha.Builder<AudioCaptcha> {
        private static final Random RAND = new Random();
        private String content = "";
        private Sample audio;
        private final List<VoiceProducer> voiceProducers = new ArrayList<VoiceProducer>();
        private final List<NoiseProducer> noiseProducers = new ArrayList<NoiseProducer>();

        public Builder addContent() {
            return this.addContent(new NumbersContentProducer());
        }

        public Builder addContent(int length) {
            return this.addContent(new NumbersContentProducer(length));
        }

        public Builder addContent(ContentProducer contentProducer) {
            this.content = this.content + contentProducer.getContent();
            return this;
        }

        public Builder addVoice() {
            this.voiceProducers.add(new RandomNumberVoiceProducer());
            return this;
        }

        public Builder addVoice(VoiceProducer voiceProducer) {
            this.voiceProducers.add(voiceProducer);
            return this;
        }

        public Builder addNoise() {
            return this.addNoise(new RandomNoiseProducer());
        }

        public Builder addNoise(NoiseProducer noiseProducer) {
            this.noiseProducers.add(noiseProducer);
            return this;
        }

        @Override
        public AudioCaptcha build() {
            if (this.voiceProducers.isEmpty()) {
                this.addVoice();
            }
            char[] ansAry = this.content.toCharArray();
            ArrayList<Sample> samples = new ArrayList<Sample>();
            for (char c : ansAry) {
                VoiceProducer vProd = this.voiceProducers.get(RAND.nextInt(this.voiceProducers.size()));
                samples.add(vProd.getVocalization(c));
            }
            if (!this.noiseProducers.isEmpty()) {
                NoiseProducer nProd = this.noiseProducers.get(RAND.nextInt(this.noiseProducers.size()));
                this.audio = nProd.addNoise(samples);
                return new AudioCaptcha(this);
            }
            this.audio = Mixer.concatenate(samples);
            return new AudioCaptcha(this);
        }
    }
}

