/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.image.BufferedImage;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.logicsquad.nanocaptcha.image.renderer.WordRenderer;

public class DefaultWordRenderer
implements WordRenderer {
    private static final Random RAND = new SecureRandom();
    private static final List<Color> DEFAULT_COLORS = new ArrayList<Color>();
    private static final List<Font> DEFAULT_FONTS = new ArrayList<Font>();
    private static final double YOFFSET = 0.25;
    private static final double XOFFSET = 0.05;
    private final List<Color> colors = new ArrayList<Color>();
    private final List<Font> fonts = new ArrayList<Font>();

    public DefaultWordRenderer() {
        this(DEFAULT_COLORS, DEFAULT_FONTS);
    }

    public DefaultWordRenderer(List<Color> colors, List<Font> fonts) {
        this.colors.addAll(colors);
        this.fonts.addAll(fonts);
    }

    @Override
    public void render(String word, BufferedImage image) {
        Graphics2D g = image.createGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        g.setRenderingHints(hints);
        FontRenderContext frc = g.getFontRenderContext();
        int xBaseline = (int)Math.round((double)image.getWidth() * 0.05);
        int yBaseline = image.getHeight() - (int)Math.round((double)image.getHeight() * 0.25);
        char[] chars = new char[1];
        char[] cArray = word.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            char c;
            chars[0] = c = cArray[i];
            g.setColor(this.colors.get(RAND.nextInt(this.colors.size())));
            int choiceFont = RAND.nextInt(this.fonts.size());
            Font font = this.fonts.get(choiceFont);
            g.setFont(font);
            GlyphVector gv = font.createGlyphVector(frc, chars);
            g.drawChars(chars, 0, chars.length, xBaseline, yBaseline);
            int width = (int)gv.getVisualBounds().getWidth();
            xBaseline += width;
        }
    }

    static {
        DEFAULT_COLORS.add(Color.BLACK);
        DEFAULT_FONTS.add(new Font("Arial", 1, 40));
        DEFAULT_FONTS.add(new Font("Courier", 1, 40));
    }
}

