/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.image.backgrounds;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import net.logicsquad.nanocaptcha.image.backgrounds.BackgroundProducer;

public final class FlatColorBackgroundProducer
implements BackgroundProducer {
    private static final Color DEFAULT_COLOR = Color.GRAY;
    private final Color color;

    public FlatColorBackgroundProducer() {
        this(DEFAULT_COLOR);
    }

    public FlatColorBackgroundProducer(Color color) {
        this.color = color;
    }

    @Override
    public BufferedImage getBackground(int width, int height) {
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D graphics = img.createGraphics();
        graphics.setPaint(this.color);
        graphics.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        graphics.drawImage((Image)img, 0, 0, null);
        graphics.dispose();
        return img;
    }
}

