/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.audio.producer;

import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.logicsquad.nanocaptcha.audio.Sample;
import net.logicsquad.nanocaptcha.audio.producer.VoiceProducer;

public class RandomNumberVoiceProducer
implements VoiceProducer {
    private static final Random RAND = new SecureRandom();
    private static final String BUILT_IN_VOICES_PREFIX = "/sounds/en/numbers/";
    private static final String[] BUILT_IN_VOICES = new String[]{"alex", "bruce", "fred", "ralph", "kathy", "vicki", "victoria"};
    private static final Map<Integer, List<String>> BUILT_IN_VOICES_MAP = new HashMap<Integer, List<String>>();
    private final Map<Integer, List<String>> voices;

    public RandomNumberVoiceProducer() {
        this(BUILT_IN_VOICES_MAP);
    }

    public RandomNumberVoiceProducer(Map<Integer, List<String>> voices) {
        this.voices = Objects.requireNonNull(voices);
    }

    @Override
    public final Sample getVocalization(char number) {
        String stringNumber = Character.toString(number);
        try {
            int idx = Integer.parseInt(stringNumber);
            List<String> files = this.voices.get(idx);
            String filename = files.get(RAND.nextInt(files.size()));
            return new Sample(filename);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("RandomNumberVoiceProducer can only vocalize numbers.");
        }
    }

    static {
        for (int i = 0; i < 10; ++i) {
            ArrayList<String> sampleNames = new ArrayList<String>();
            for (String name : Arrays.asList(BUILT_IN_VOICES)) {
                StringBuilder sb = new StringBuilder(BUILT_IN_VOICES_PREFIX);
                sb.append(i);
                sb.append("-");
                sb.append(name);
                sb.append(".wav");
                sampleNames.add(sb.toString());
            }
            BUILT_IN_VOICES_MAP.put(i, sampleNames);
        }
    }
}

