/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class Sample {
    public static final AudioFormat SC_AUDIO_FORMAT = new AudioFormat(16000.0f, 16, 1, true, false);
    private final AudioInputStream audioInputStream;

    public Sample(String filename) {
        this(Sample.class.getResourceAsStream(Objects.requireNonNull(filename)));
    }

    public Sample(InputStream is) {
        Objects.requireNonNull(is);
        if (is instanceof AudioInputStream) {
            this.audioInputStream = (AudioInputStream)is;
        } else {
            try {
                this.audioInputStream = AudioSystem.getAudioInputStream(is);
            }
            catch (UnsupportedAudioFileException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (!this.audioInputStream.getFormat().matches(SC_AUDIO_FORMAT)) {
            throw new IllegalArgumentException("Unsupported audio format.");
        }
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioInputStream;
    }

    private AudioFormat getFormat() {
        return this.audioInputStream.getFormat();
    }

    long getSampleCount() {
        long total = this.audioInputStream.getFrameLength() * (long)this.getFormat().getFrameSize() * 8L / (long)this.getFormat().getSampleSizeInBits();
        return total / (long)this.getFormat().getChannels();
    }

    double[] getInterleavedSamples() {
        double[] samples = new double[(int)this.getSampleCount()];
        try {
            this.getInterleavedSamples(0L, this.getSampleCount(), samples);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return samples;
    }

    private double[] getInterleavedSamples(long start, long end, double[] samples) throws IOException, IllegalArgumentException {
        long nbSamples = end - start;
        long nbBytes = nbSamples * (long)(this.getFormat().getSampleSizeInBits() / 8) * (long)this.getFormat().getChannels();
        if (nbBytes > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Too many samples. Try using a smaller wav.");
        }
        byte[] inBuffer = new byte[(int)nbBytes];
        this.audioInputStream.read(inBuffer, 0, inBuffer.length);
        this.decodeBytes(inBuffer, samples);
        return samples;
    }

    private void decodeBytes(byte[] audioBytes, double[] audioSamples) {
        int sampleSizeInBytes = this.getFormat().getSampleSizeInBits() / 8;
        int[] sampleBytes = new int[sampleSizeInBytes];
        int k = 0;
        for (int i = 0; i < audioSamples.length; ++i) {
            double val;
            int j;
            if (this.getFormat().isBigEndian()) {
                for (j = 0; j < sampleSizeInBytes; ++j) {
                    sampleBytes[j] = audioBytes[k++];
                }
            } else {
                for (j = sampleSizeInBytes - 1; j >= 0; --j) {
                    sampleBytes[j] = audioBytes[k++];
                    if (sampleBytes[j] == 0) continue;
                    j += 0;
                }
            }
            int ival = 0;
            for (int j2 = 0; j2 < sampleSizeInBytes; ++j2) {
                ival += sampleBytes[j2];
                if (j2 >= sampleSizeInBytes - 1) continue;
                ival <<= 8;
            }
            double ratio = Math.pow(2.0, this.getFormat().getSampleSizeInBits() - 1);
            audioSamples[i] = val = (double)ival / ratio;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Sample: samples=").append(this.getSampleCount()).append(" format=").append(this.getFormat()).append("]");
        return sb.toString();
    }
}

