/*
 * Decompiled with CFR 0.152.
 */
package net.logicsquad.nanocaptcha.audio;

import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.sound.sampled.AudioInputStream;
import net.logicsquad.nanocaptcha.audio.Sample;

public final class Mixer {
    private Mixer() {
        throw new AssertionError();
    }

    public static Sample concatenate(List<Sample> samples) {
        Objects.requireNonNull(samples);
        if (samples.isEmpty()) {
            return Mixer.buildSample(0L, new double[0]);
        }
        int sampleCount = 0;
        double[] first = samples.get(0).getInterleavedSamples();
        sampleCount = (int)((long)sampleCount + samples.get(0).getSampleCount());
        double[][] samplesArray = new double[samples.size() - 1][];
        for (int i = 0; i < samplesArray.length; ++i) {
            samplesArray[i] = samples.get(i + 1).getInterleavedSamples();
            sampleCount = (int)((long)sampleCount + samples.get(i + 1).getSampleCount());
        }
        double[] appended = Mixer.concatenate(first, samplesArray);
        return Mixer.buildSample(sampleCount, appended);
    }

    public static Sample mix(Sample sample1, double volume1, Sample sample2, double volume2) {
        Objects.requireNonNull(sample1);
        Objects.requireNonNull(sample2);
        double[] s1Array = sample1.getInterleavedSamples();
        double[] s2Array = sample2.getInterleavedSamples();
        double[] mixed = Mixer.mix(s1Array, volume1, s2Array, volume2);
        return Mixer.buildSample(sample1.getSampleCount(), mixed);
    }

    private static double[] concatenate(double[] first, double[] ... rest) {
        int totalLength = first.length;
        for (double[] array : rest) {
            totalLength += array.length;
        }
        double[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (double[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    private static double[] mix(double[] sample1, double volume1, double[] sample2, double volume2) {
        for (int i = 0; i < sample1.length; ++i) {
            if (i >= sample2.length) {
                sample1[i] = 0.0;
                break;
            }
            sample1[i] = sample1[i] * volume1 + sample2[i] * volume2;
        }
        return sample1;
    }

    private static Sample buildSample(long sampleCount, double[] sample) {
        byte[] buffer = Mixer.asByteArray(sampleCount, sample);
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        AudioInputStream ais = new AudioInputStream(bais, Sample.SC_AUDIO_FORMAT, sampleCount);
        return new Sample(ais);
    }

    private static byte[] asByteArray(long sampleCount, double[] sample) {
        int b_len = (int)sampleCount * (Sample.SC_AUDIO_FORMAT.getSampleSizeInBits() / 8);
        byte[] buffer = new byte[b_len];
        for (int i = 0; i < sample.length; ++i) {
            int in = (int)(sample[i] * 32767.0);
            buffer[2 * i] = (byte)(in & 0xFF);
            buffer[2 * i + 1] = (byte)(in >> 8);
        }
        return buffer;
    }
}

