/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.lightbody.bmp.proxy.jetty.util.IO;
import net.lightbody.bmp.proxy.jetty.util.InetAddrPort;

public class ProxyServlet
implements Servlet {
    private int _tunnelTimeoutMs = 3000;
    protected HashSet _DontProxyHeaders = new HashSet();
    private ServletConfig config;
    private ServletContext context;

    public ProxyServlet() {
        this._DontProxyHeaders.add("proxy-connection");
        this._DontProxyHeaders.add("connection");
        this._DontProxyHeaders.add("keep-alive");
        this._DontProxyHeaders.add("transfer-encoding");
        this._DontProxyHeaders.add("te");
        this._DontProxyHeaders.add("trailer");
        this._DontProxyHeaders.add("proxy-authorization");
        this._DontProxyHeaders.add("proxy-authenticate");
        this._DontProxyHeaders.add("upgrade");
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
    }

    public ServletConfig getServletConfig() {
        return this.config;
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
        } else {
            String cache_control;
            String connectionHdr;
            String uri = request.getRequestURI();
            if (request.getQueryString() != null) {
                uri = uri + "?" + request.getQueryString();
            }
            URL url = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), uri);
            this.context.log("URL=" + url);
            URLConnection connection = url.openConnection();
            connection.setAllowUserInteraction(false);
            HttpURLConnection http = null;
            if (connection instanceof HttpURLConnection) {
                http = (HttpURLConnection)connection;
                http.setRequestMethod(request.getMethod());
                http.setInstanceFollowRedirects(false);
            }
            if ((connectionHdr = request.getHeader("Connection")) != null && ((connectionHdr = connectionHdr.toLowerCase()).equals("keep-alive") || connectionHdr.equals("close"))) {
                connectionHdr = null;
            }
            boolean xForwardedFor = false;
            boolean hasContent = false;
            Enumeration enm = request.getHeaderNames();
            while (enm.hasMoreElements()) {
                String hdr = (String)enm.nextElement();
                String lhdr = hdr.toLowerCase();
                if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
                if ("content-type".equals(lhdr)) {
                    hasContent = true;
                }
                Enumeration vals = request.getHeaders(hdr);
                while (vals.hasMoreElements()) {
                    String val = (String)vals.nextElement();
                    if (val == null) continue;
                    connection.addRequestProperty(hdr, val);
                    this.context.log("req " + hdr + ": " + val);
                    xForwardedFor |= "X-Forwarded-For".equalsIgnoreCase(hdr);
                }
            }
            connection.setRequestProperty("Via", "1.1 (jetty)");
            if (!xForwardedFor) {
                connection.addRequestProperty("X-Forwarded-For", request.getRemoteAddr());
            }
            if ((cache_control = request.getHeader("Cache-Control")) != null && (cache_control.indexOf("no-cache") >= 0 || cache_control.indexOf("no-store") >= 0)) {
                connection.setUseCaches(false);
            }
            try {
                connection.setDoInput(true);
                ServletInputStream in = request.getInputStream();
                if (hasContent) {
                    connection.setDoOutput(true);
                    IO.copy((InputStream)in, connection.getOutputStream());
                }
                connection.connect();
            }
            catch (Exception e) {
                this.context.log("proxy", (Throwable)e);
            }
            InputStream proxy_in = null;
            int code = 500;
            if (http != null) {
                proxy_in = http.getErrorStream();
                code = http.getResponseCode();
                response.setStatus(code, http.getResponseMessage());
                this.context.log("response = " + http.getResponseCode());
            }
            if (proxy_in == null) {
                try {
                    proxy_in = connection.getInputStream();
                }
                catch (Exception e) {
                    this.context.log("stream", (Throwable)e);
                    proxy_in = http.getErrorStream();
                }
            }
            response.setHeader("Date", null);
            response.setHeader("Server", null);
            int h = 0;
            String hdr = connection.getHeaderFieldKey(h);
            String val = connection.getHeaderField(h);
            while (hdr != null || val != null) {
                String lhdr;
                String string = lhdr = hdr != null ? hdr.toLowerCase() : null;
                if (hdr != null && val != null && !this._DontProxyHeaders.contains(lhdr)) {
                    response.addHeader(hdr, val);
                }
                this.context.log("res " + hdr + ": " + val);
                hdr = connection.getHeaderFieldKey(++h);
                val = connection.getHeaderField(h);
            }
            response.addHeader("Via", "1.1 (jetty)");
            if (proxy_in != null) {
                IO.copy(proxy_in, (OutputStream)response.getOutputStream());
            }
        }
    }

    public void handleConnect(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String uri = request.getRequestURI();
        this.context.log("CONNECT: " + uri);
        InetAddrPort addrPort = new InetAddrPort(uri);
        ServletInputStream in = request.getInputStream();
        ServletOutputStream out = response.getOutputStream();
        Socket socket = new Socket(addrPort.getInetAddress(), addrPort.getPort());
        this.context.log("Socket: " + socket);
        response.setStatus(200);
        response.setHeader("Connection", "close");
        response.flushBuffer();
        System.err.println(response);
        this.context.log("out<-in");
        IO.copyThread(socket.getInputStream(), (OutputStream)out);
        this.context.log("in->out");
        IO.copy((InputStream)in, socket.getOutputStream());
    }

    public String getServletInfo() {
        return "Proxy Servlet";
    }

    public void destroy() {
    }
}

