/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.jetty.servlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PostFileFilter
implements Filter {
    ServletContext _context;
    int _bufferSize = 8092;
    String _response = "nocontent";

    public void init(FilterConfig filterConfig) throws ServletException {
        this._context = filterConfig.getServletContext();
        String tmp = filterConfig.getInitParameter("bufferSize");
        if (tmp != null) {
            this._bufferSize = Integer.parseInt(tmp);
        }
        if ((tmp = filterConfig.getInitParameter("response")) != null) {
            this._response = tmp;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        HttpServletResponse sresponse = (HttpServletResponse)response;
        if ("POST".equalsIgnoreCase(srequest.getMethod())) {
            int len;
            String filename = srequest.getPathTranslated();
            if (filename == null) {
                filename = srequest.getPathInfo() == null ? this._context.getRealPath(srequest.getServletPath()) : this._context.getRealPath(srequest.getServletPath() + srequest.getPathInfo());
            }
            if (filename == null) {
                sresponse.sendError(404);
                return;
            }
            if (srequest.getContentLength() == 0) {
                sresponse.sendError(411);
                return;
            }
            File file = new File(filename);
            if (!((!file.exists() || file.canWrite() && !file.isDirectory()) && (file.exists() || file.getParentFile().exists() && file.getParentFile().isDirectory() && file.getParentFile().canWrite()))) {
                sresponse.sendError(403, "No write permission");
                return;
            }
            ServletInputStream in = srequest.getInputStream();
            FileOutputStream out = new FileOutputStream(file, false);
            byte[] buf = new byte[this._bufferSize];
            while ((len = in.read(buf)) >= 0) {
                out.write(buf, 0, len);
            }
            out.close();
            if ("redirect".equalsIgnoreCase(this._response)) {
                sresponse.sendRedirect(srequest.getRequestURI());
            } else if ("chain".equalsIgnoreCase(this._response)) {
                chain.doFilter(request, response);
            } else if ("ok".equalsIgnoreCase(this._response)) {
                sresponse.setStatus(200);
            } else {
                sresponse.setStatus(204);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

