/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.http;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.lightbody.bmp.proxy.http.RequestInfo;
import org.apache.http.conn.DnsResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Address;
import org.xbill.DNS.Cache;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.TextParseException;

public class BrowserMobHostNameResolver
implements DnsResolver {
    public static final String ALLOW_NATIVE_DNS_FALLBACK = "bmp.allowNativeDnsFallback";
    private static final int MAX_RETRY_COUNT = 5;
    private static final Logger LOG = LoggerFactory.getLogger(BrowserMobHostNameResolver.class);
    private Map<String, String> remappings = new ConcurrentHashMap<String, String>();
    private Map<String, List<String>> reverseMapping = new ConcurrentHashMap<String, List<String>>();
    private Cache cache;
    private Resolver resolver;

    public BrowserMobHostNameResolver(Cache cache) {
        this.cache = cache;
        try {
            this.resolver = new ExtendedResolver();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public BrowserMobHostNameResolver(Cache cache, Resolver resolver) {
        this.cache = cache;
        this.resolver = resolver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InetAddress[] resolve(String hostname) throws UnknownHostException {
        String remapping = this.remappings.get(hostname);
        if (remapping != null) {
            hostname = remapping;
        }
        try {
            return new InetAddress[]{Address.getByAddress(hostname)};
        }
        catch (UnknownHostException e) {
            List<Object> addrList;
            boolean isCached;
            try {
                isCached = this.isCached(hostname);
            }
            catch (TextParseException e2) {
                throw new UnknownHostException(hostname);
            }
            Date start = new Date();
            Record[] records = this.findByDNS(hostname);
            Date end = new Date();
            if (records == null || records.length == 0) {
                if (!Boolean.getBoolean(ALLOW_NATIVE_DNS_FALLBACK)) throw new UnknownHostException(hostname);
                InetAddress[] addresses = this.findByNativeLookup(hostname);
                addrList = Arrays.asList(addresses);
            } else {
                addrList = new ArrayList(records.length);
                for (Record record : records) {
                    ARecord a = (ARecord)record;
                    InetAddress addr = InetAddress.getByAddress(hostname, a.getAddress().getAddress());
                    addrList.add(addr);
                }
            }
            if (!isCached) {
                RequestInfo.get().dns(start, end, ((InetAddress)addrList.get(0)).getHostAddress());
                return addrList.toArray(new InetAddress[0]);
            } else {
                RequestInfo.get().dns(end, end, ((InetAddress)addrList.get(0)).getHostAddress());
            }
            return addrList.toArray(new InetAddress[0]);
        }
    }

    private InetAddress[] findByNativeLookup(String hostname) throws UnknownHostException {
        return InetAddress.getAllByName(hostname);
    }

    private Record[] findByDNS(String hostname) throws UnknownHostException {
        Record[] records;
        Lookup lookup;
        try {
            lookup = new Lookup(Name.fromString(hostname), 1);
        }
        catch (TextParseException e) {
            throw new UnknownHostException(hostname);
        }
        lookup.setCache(this.cache);
        lookup.setResolver(this.resolver);
        int retryCount = -1;
        do {
            records = lookup.run();
        } while (lookup.getResult() == 2 && ++retryCount < 5);
        return records;
    }

    public void remap(String source, String target) {
        this.remappings.put(source, target);
        List<String> list = this.reverseMapping.get(target);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(source);
        this.reverseMapping.put(target, list);
    }

    public String remapping(String host) {
        return this.remappings.get(host);
    }

    public List<String> original(String host) {
        return this.reverseMapping.get(host);
    }

    public void clearCache() {
        this.cache.clearCache();
    }

    public void setCacheTimeout(int timeout) {
        this.cache.setMaxCache(timeout);
    }

    public boolean isCached(String hostname) throws TextParseException {
        return this.cache.lookupRecords(Name.fromString(hostname), 255, 3).isSuccessful();
    }
}

