/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy;

import java.util.regex.Pattern;

public class BlacklistEntry {
    private final Pattern urlPattern;
    private final int statusCode;
    private final Pattern httpMethodPattern;

    public BlacklistEntry(String urlPattern, int statusCode) {
        this(urlPattern, statusCode, null);
    }

    public BlacklistEntry(String urlPattern, int statusCode, String httpMethodPattern) {
        this.urlPattern = Pattern.compile(urlPattern);
        this.statusCode = statusCode;
        this.httpMethodPattern = httpMethodPattern == null || httpMethodPattern.isEmpty() ? null : Pattern.compile(httpMethodPattern);
    }

    public boolean matches(String url, String httpMethod) {
        if (this.httpMethodPattern != null) {
            return this.urlPattern.matcher(url).matches() && this.httpMethodPattern.matcher(httpMethod).matches();
        }
        return this.urlPattern.matcher(url).matches();
    }

    public Pattern getUrlPattern() {
        return this.urlPattern;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Pattern getHttpMethodPattern() {
        return this.httpMethodPattern;
    }

    @Deprecated
    public Pattern getPattern() {
        return this.getUrlPattern();
    }

    @Deprecated
    public int getResponseCode() {
        return this.getStatusCode();
    }

    @Deprecated
    public Pattern getMethod() {
        return this.getHttpMethodPattern();
    }
}

