/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.filters;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.net.HostAndPort;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.littleshoot.proxy.HttpFiltersAdapter;

public class ResolvedHostnameCacheFilter
extends HttpFiltersAdapter {
    private static final int RESOLVED_ADDRESSES_EVICTION_SECONDS = 600;
    private static final int RESOLVED_ADDRESSES_CONCURRENCY_LEVEL = 50;
    private static final Cache<String, String> resolvedAddresses = CacheBuilder.newBuilder().expireAfterAccess(600L, TimeUnit.SECONDS).concurrencyLevel(50).build();

    public ResolvedHostnameCacheFilter(HttpRequest originalRequest, ChannelHandlerContext ctx) {
        super(originalRequest, ctx);
    }

    public void proxyToServerResolutionSucceeded(String serverHostAndPort, InetSocketAddress resolvedRemoteAddress) {
        HostAndPort parsedHostAndPort;
        String host;
        InetAddress resolvedAddress = resolvedRemoteAddress.getAddress();
        if (resolvedAddress != null && (host = (parsedHostAndPort = HostAndPort.fromString((String)serverHostAndPort)).getHost()) != null && !host.isEmpty()) {
            resolvedAddresses.put((Object)host, (Object)resolvedAddress.getHostAddress());
        }
    }

    public static String getPreviouslyResolvedAddressForHost(String host) {
        return (String)resolvedAddresses.getIfPresent((Object)host);
    }
}

