/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.ssl;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.littleshoot.proxy.SslEngineSource;

public class BrowserMobSslEngineSource
implements SslEngineSource {
    private static final String KEYSTORE_RESOURCE = "/sslSupport/cybervillainsCA.jks";
    private static final char[] KEYSTORE_PASSWORD = "password".toCharArray();
    private final SSLContext sslContext = this.initializeSSLContext();

    public SSLEngine newSslEngine() {
        return this.sslContext.createSSLEngine();
    }

    public SSLEngine newSslEngine(String host, int port) {
        return this.sslContext.createSSLEngine(host, port);
    }

    private SSLContext initializeSSLContext() {
        InputStream keystoreStream;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        if ((keystoreStream = this.getClass().getResourceAsStream(KEYSTORE_RESOURCE)) == null) {
            throw new RuntimeException("Unable to load keystore from classpath resource: /sslSupport/cybervillainsCA.jks");
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(keystoreStream, KEYSTORE_PASSWORD);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, KEYSTORE_PASSWORD);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(algorithm);
            tmf.init(ks);
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            KeyManager[] keyManagers = kmf.getKeyManagers();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagers, trustManagers, null);
            return sslContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize the server-side SSLContext", e);
        }
    }
}

