/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.proxy.dns;

import com.google.common.collect.Iterables;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;
import org.littleshoot.proxy.HostResolver;

public class DelegatingHostResolver
implements HostResolver {
    private volatile AdvancedHostResolver resolver;

    public DelegatingHostResolver(AdvancedHostResolver resolver) {
        this.resolver = resolver;
    }

    public AdvancedHostResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(AdvancedHostResolver resolver) {
        this.resolver = resolver;
    }

    public InetSocketAddress resolve(String host, int port) throws UnknownHostException {
        Collection resolvedAddresses = this.resolver.resolve(host);
        if (!resolvedAddresses.isEmpty()) {
            InetAddress resolvedAddress = (InetAddress)Iterables.get((Iterable)resolvedAddresses, (int)0);
            return new InetSocketAddress(resolvedAddress, port);
        }
        throw new UnknownHostException(host);
    }
}

