/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapMaker;
import com.google.common.net.HostAndPort;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import net.lightbody.bmp.BrowserMobProxy;
import net.lightbody.bmp.client.ClientUtil;
import net.lightbody.bmp.core.har.Har;
import net.lightbody.bmp.core.har.HarLog;
import net.lightbody.bmp.core.har.HarNameVersion;
import net.lightbody.bmp.core.har.HarPage;
import net.lightbody.bmp.exception.NameResolutionException;
import net.lightbody.bmp.filters.AddHeadersFilter;
import net.lightbody.bmp.filters.BlacklistFilter;
import net.lightbody.bmp.filters.BrowserMobHttpFilterChain;
import net.lightbody.bmp.filters.HarCaptureFilter;
import net.lightbody.bmp.filters.HttpConnectHarCaptureFilter;
import net.lightbody.bmp.filters.HttpsHostCaptureFilter;
import net.lightbody.bmp.filters.HttpsOriginalHostCaptureFilter;
import net.lightbody.bmp.filters.LatencyFilter;
import net.lightbody.bmp.filters.RegisterRequestFilter;
import net.lightbody.bmp.filters.RequestFilter;
import net.lightbody.bmp.filters.RequestFilterAdapter;
import net.lightbody.bmp.filters.ResolvedHostnameCacheFilter;
import net.lightbody.bmp.filters.ResponseFilter;
import net.lightbody.bmp.filters.ResponseFilterAdapter;
import net.lightbody.bmp.filters.RewriteUrlFilter;
import net.lightbody.bmp.filters.UnregisterRequestFilter;
import net.lightbody.bmp.filters.WhitelistFilter;
import net.lightbody.bmp.proxy.ActivityMonitor;
import net.lightbody.bmp.proxy.BlacklistEntry;
import net.lightbody.bmp.proxy.CaptureType;
import net.lightbody.bmp.proxy.LegacyProxyServer;
import net.lightbody.bmp.proxy.RewriteRule;
import net.lightbody.bmp.proxy.Whitelist;
import net.lightbody.bmp.proxy.auth.AuthType;
import net.lightbody.bmp.proxy.dns.AdvancedHostResolver;
import net.lightbody.bmp.proxy.dns.DelegatingHostResolver;
import net.lightbody.bmp.proxy.http.RequestInterceptor;
import net.lightbody.bmp.proxy.http.ResponseInterceptor;
import net.lightbody.bmp.proxy.util.BrowserMobProxyUtil;
import net.lightbody.bmp.ssl.BrowserMobProxyMitmManager;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.java_bandwidthlimiter.StreamManager;
import org.littleshoot.proxy.ChainedProxy;
import org.littleshoot.proxy.ChainedProxyAdapter;
import org.littleshoot.proxy.ChainedProxyManager;
import org.littleshoot.proxy.HostResolver;
import org.littleshoot.proxy.HttpFilters;
import org.littleshoot.proxy.HttpFiltersSource;
import org.littleshoot.proxy.HttpFiltersSourceAdapter;
import org.littleshoot.proxy.HttpProxyServer;
import org.littleshoot.proxy.HttpProxyServerBootstrap;
import org.littleshoot.proxy.MitmManager;
import org.littleshoot.proxy.impl.DefaultHttpProxyServer;
import org.littleshoot.proxy.impl.ProxyUtils;
import org.littleshoot.proxy.impl.ThreadPoolConfiguration;
import org.openqa.selenium.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserMobProxyServer
implements BrowserMobProxy,
LegacyProxyServer {
    private static final Logger log = LoggerFactory.getLogger(BrowserMobProxyServer.class);
    private static final HarNameVersion HAR_CREATOR_VERSION = new HarNameVersion("BrowserMob Proxy", "2.1.0-beta-3-littleproxy");
    public static final String VIA_HEADER_ALIAS = "browsermobproxy";
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final AtomicInteger harPageCount = new AtomicInteger(0);
    private volatile boolean mitmDisabled = false;
    private final List<HttpFiltersSource> filterFactories = new CopyOnWriteArrayList<HttpFiltersSource>();
    private volatile Collection<BlacklistEntry> blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>();
    private volatile CopyOnWriteArrayList<RewriteRule> rewriteRules = new CopyOnWriteArrayList();
    private volatile HttpProxyServer proxyServer;
    private volatile int port = 0;
    private volatile EnumSet<CaptureType> harCaptureTypes = CaptureType.getCookieCaptureTypes();
    private volatile Har har;
    private volatile HarPage currentHarPage;
    private volatile long readBandwidthLimitBps;
    private volatile long writeBandwidthLimitBps;
    private final AtomicReference<Whitelist> whitelist = new AtomicReference<Whitelist>(Whitelist.WHITELIST_DISABLED);
    private volatile ConcurrentMap<String, String> additionalHeaders = new MapMaker().concurrencyLevel(1).makeMap();
    private volatile int connectTimeoutMs;
    private volatile int idleConnectionTimeoutSec;
    private volatile int latencyMs;
    private final AtomicBoolean harCaptureFilterEnabled = new AtomicBoolean(false);
    private volatile InetSocketAddress upstreamProxyAddress;
    private volatile ChainedProxyManager chainedProxyManager;
    private volatile InetSocketAddress clientBindSocket;
    private volatile InetAddress serverBindAddress;
    private volatile boolean legacyClientBindSocketSet;
    private volatile boolean errorOnUnsupportedOperation = false;
    private final DelegatingHostResolver delegatingResolver = new DelegatingHostResolver(ClientUtil.createNativeCacheManipulatingResolver());
    private final ActivityMonitor activityMonitor = new ActivityMonitor();
    private volatile ThreadPoolConfiguration threadPoolConfiguration;
    private final StreamManagerLegacyAdapter streamManagerAdapter = new StreamManagerLegacyAdapter();

    public BrowserMobProxyServer() {
        this(0);
    }

    public BrowserMobProxyServer(int port) {
        this.port = port;
    }

    public void start(int port, InetAddress clientBindAddress, InetAddress serverBindAddress) {
        boolean notStarted = this.started.compareAndSet(false, true);
        if (!notStarted) {
            throw new IllegalStateException("Proxy server is already started. Not restarting.");
        }
        this.clientBindSocket = this.legacyClientBindSocketSet ? new InetSocketAddress(this.clientBindSocket.getAddress(), port) : (clientBindAddress == null ? new InetSocketAddress(port) : new InetSocketAddress(clientBindAddress, port));
        this.serverBindAddress = serverBindAddress;
        this.addBrowserMobFilters();
        HttpProxyServerBootstrap bootstrap = DefaultHttpProxyServer.bootstrap().withFiltersSource(new HttpFiltersSource(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext channelHandlerContext) {
                return new BrowserMobHttpFilterChain(BrowserMobProxyServer.this, originalRequest, channelHandlerContext);
            }

            public int getMaximumRequestBufferSizeInBytes() {
                return BrowserMobProxyServer.this.getMaximumRequestBufferSize();
            }

            public int getMaximumResponseBufferSizeInBytes() {
                return BrowserMobProxyServer.this.getMaximumResponseBufferSize();
            }
        }).withServerResolver((HostResolver)this.delegatingResolver).withAddress(this.clientBindSocket).withConnectTimeout(this.connectTimeoutMs).withIdleConnectionTimeout(this.idleConnectionTimeoutSec).withProxyAlias(VIA_HEADER_ALIAS);
        if (serverBindAddress != null) {
            bootstrap.withNetworkInterface(new InetSocketAddress(serverBindAddress, 0));
        }
        if (!this.mitmDisabled) {
            bootstrap.withManInTheMiddle((MitmManager)new BrowserMobProxyMitmManager());
        }
        if (this.readBandwidthLimitBps > 0L || this.writeBandwidthLimitBps > 0L) {
            bootstrap.withThrottling(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
        if (this.chainedProxyManager != null) {
            bootstrap.withChainProxyManager(this.chainedProxyManager);
        } else if (this.upstreamProxyAddress != null) {
            bootstrap.withChainProxyManager(new ChainedProxyManager(){

                public void lookupChainedProxies(HttpRequest httpRequest, Queue<ChainedProxy> chainedProxies) {
                    final InetSocketAddress upstreamProxy = BrowserMobProxyServer.this.upstreamProxyAddress;
                    if (upstreamProxy != null) {
                        chainedProxies.add((ChainedProxy)new ChainedProxyAdapter(){

                            public InetSocketAddress getChainedProxyAddress() {
                                return upstreamProxy;
                            }
                        });
                    }
                }
            });
        }
        if (this.threadPoolConfiguration != null) {
            bootstrap.withThreadPoolConfiguration(this.threadPoolConfiguration);
        }
        this.proxyServer = bootstrap.start();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start(int port) {
        this.start(port, null, null);
    }

    public void start(int port, InetAddress bindAddress) {
        this.start(port, bindAddress, null);
    }

    public void start() {
        this.start(this.port);
    }

    @Deprecated
    public Proxy seleniumProxy() throws NameResolutionException {
        return ClientUtil.createSeleniumProxy((BrowserMobProxy)this);
    }

    public void stop() {
        this.stop(true);
    }

    public void abort() {
        this.stop(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void stop(boolean graceful) {
        if (!this.isStarted()) throw new IllegalStateException("Proxy server has not been started");
        if (!this.stopped.compareAndSet(false, true)) throw new IllegalStateException("Proxy server is already stopped. Cannot re-stop.");
        if (this.proxyServer != null) {
            if (graceful) {
                this.proxyServer.stop();
                return;
            } else {
                this.proxyServer.abort();
            }
            return;
        } else {
            log.warn("Attempted to stop proxy server, but proxy was never successfully started.");
        }
    }

    public InetAddress getClientBindAddress() {
        if (this.clientBindSocket == null) {
            return null;
        }
        return this.clientBindSocket.getAddress();
    }

    @Deprecated
    public void cleanup() {
    }

    public int getPort() {
        if (this.started.get()) {
            return this.proxyServer.getListenAddress().getPort();
        }
        return this.port;
    }

    @Deprecated
    public void setPort(int port) {
        this.port = port;
    }

    @Deprecated
    public InetAddress getLocalHost() {
        return this.getClientBindAddress();
    }

    @Deprecated
    public InetAddress getConnectableLocalHost() throws UnknownHostException {
        return ClientUtil.getConnectableAddress();
    }

    @Deprecated
    public void setLocalHost(InetAddress localHost) {
        this.legacyClientBindSocketSet = true;
        this.clientBindSocket = new InetSocketAddress(localHost, 0);
    }

    public InetAddress getServerBindAddress() {
        return this.serverBindAddress;
    }

    public Har getHar() {
        return this.har;
    }

    public Har newHar() {
        return this.newHar(null);
    }

    public Har newHar(String initialPageRef) {
        return this.newHar(initialPageRef, null);
    }

    public Har newHar(String initialPageRef, String initialPageTitle) {
        BrowserMobProxyUtil.getUserAgentStringParser();
        Har oldHar = this.getHar();
        this.addHarCaptureFilter();
        this.harPageCount.set(0);
        this.har = new Har(new HarLog(HAR_CREATOR_VERSION));
        this.newPage(initialPageRef, initialPageTitle);
        return oldHar;
    }

    public void setHarCaptureTypes(Set<CaptureType> harCaptureSettings) {
        this.harCaptureTypes = harCaptureSettings == null || harCaptureSettings.isEmpty() ? EnumSet.noneOf(CaptureType.class) : EnumSet.copyOf(harCaptureSettings);
    }

    public void setHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.setHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.setHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    public EnumSet<CaptureType> getHarCaptureTypes() {
        return EnumSet.copyOf(this.harCaptureTypes);
    }

    public void enableHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.harCaptureTypes.addAll(captureTypes);
    }

    public void enableHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.enableHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.enableHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    public void disableHarCaptureTypes(Set<CaptureType> captureTypes) {
        this.harCaptureTypes.removeAll(captureTypes);
    }

    public void disableHarCaptureTypes(CaptureType ... captureTypes) {
        if (captureTypes == null) {
            this.disableHarCaptureTypes(EnumSet.noneOf(CaptureType.class));
        } else {
            this.disableHarCaptureTypes(EnumSet.copyOf(Arrays.asList(captureTypes)));
        }
    }

    public Har newPage() {
        return this.newPage(null);
    }

    public Har newPage(String pageRef) {
        return this.newPage(pageRef, null);
    }

    public Har newPage(String pageRef, String pageTitle) {
        if (this.har == null) {
            throw new IllegalStateException("No HAR exists for this proxy. Use newHar() to create a new HAR before calling newPage().");
        }
        Har endOfPageHar = null;
        if (this.currentHarPage != null) {
            String currentPageRef = this.currentHarPage.getId();
            this.endPage();
            endOfPageHar = BrowserMobProxyUtil.copyHarThroughPageRef((Har)this.har, (String)currentPageRef);
        }
        if (pageRef == null) {
            pageRef = "Page " + this.harPageCount.getAndIncrement();
        }
        if (pageTitle == null) {
            pageTitle = pageRef;
        }
        HarPage newPage = new HarPage(pageRef, pageTitle);
        this.har.getLog().addPage(newPage);
        this.currentHarPage = newPage;
        return endOfPageHar;
    }

    public Har endHar() {
        Har oldHar = this.getHar();
        this.endPage();
        this.har = null;
        return oldHar;
    }

    public void setReadBandwidthLimit(long bytesPerSecond) {
        this.readBandwidthLimitBps = bytesPerSecond;
        if (this.isStarted()) {
            this.proxyServer.setThrottle(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
    }

    public void setWriteBandwidthLimit(long bytesPerSecond) {
        this.writeBandwidthLimitBps = bytesPerSecond;
        if (this.isStarted()) {
            this.proxyServer.setThrottle(this.readBandwidthLimitBps, this.writeBandwidthLimitBps);
        }
    }

    public void endPage() {
        if (this.har == null) {
            throw new IllegalStateException("No HAR exists for this proxy. Use newHar() to create a new HAR.");
        }
        HarPage previousPage = this.currentHarPage;
        this.currentHarPage = null;
        if (previousPage == null) {
            return;
        }
        previousPage.getPageTimings().setOnLoad(Long.valueOf(new Date().getTime() - previousPage.getStartedDateTime().getTime()));
    }

    public void setRetryCount(int count) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    public void addHeaders(Map<String, String> headers) {
        ConcurrentMap newHeaders = new MapMaker().concurrencyLevel(1).makeMap();
        newHeaders.putAll(headers);
        this.additionalHeaders = newHeaders;
    }

    @Deprecated
    public void remapHost(String source, String target) {
        AdvancedHostResolver advancedResolver = this.delegatingResolver.getResolver();
        advancedResolver.remapHost(source, target);
    }

    @Deprecated
    public void addRequestInterceptor(HttpRequestInterceptor i) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Deprecated
    public void addRequestInterceptor(RequestInterceptor interceptor) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Deprecated
    public void addResponseInterceptor(HttpResponseInterceptor i) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Deprecated
    public void addResponseInterceptor(ResponseInterceptor interceptor) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Deprecated
    public StreamManager getStreamManager() {
        return this.streamManagerAdapter;
    }

    @Deprecated
    public void setDownstreamKbps(long downstreamKbps) {
        this.setWriteBandwidthLimit(downstreamKbps * 1024L);
    }

    @Deprecated
    public void setUpstreamKbps(long upstreamKbps) {
        this.setReadBandwidthLimit(upstreamKbps * 1024L);
    }

    @Deprecated
    public void setLatency(long latencyMs) {
        this.setLatency(latencyMs, TimeUnit.MILLISECONDS);
    }

    public void setLatency(long latency, TimeUnit timeUnit) {
        this.latencyMs = (int)TimeUnit.MILLISECONDS.convert(latency, timeUnit);
    }

    public void autoAuthorization(String domain, String username, String password, AuthType authType) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    public void stopAutoAuthorization(String domain) {
        if (this.errorOnUnsupportedOperation) {
            throw new UnsupportedOperationException("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
        }
        log.warn("No LittleProxy implementation for operation: " + new Throwable().getStackTrace()[0].getMethodName());
    }

    @Deprecated
    public void setReadLimitKbps(long readLimitKbps) {
        this.setReadBandwidthLimit(readLimitKbps * 1024L);
    }

    @Deprecated
    public void setWriteLimitKbps(long writeLimitKbps) {
        this.setWriteBandwidthLimit(writeLimitKbps * 1024L);
    }

    public void setConnectTimeout(int connectTimeout, TimeUnit timeUnit) {
        if (this.isStarted()) {
            throw new IllegalStateException("LittleProxy implementation does not allow changes to connect timeout after proxy has been started");
        }
        this.connectTimeoutMs = (int)TimeUnit.MILLISECONDS.convert(connectTimeout, timeUnit);
    }

    public void setIdleConnectionTimeout(int idleConnectionTimeout, TimeUnit timeUnit) {
        long timeout = TimeUnit.SECONDS.convert(idleConnectionTimeout, TimeUnit.MILLISECONDS);
        this.idleConnectionTimeoutSec = timeout == 0L && idleConnectionTimeout > 0 ? 1 : (int)timeout;
        if (this.isStarted()) {
            this.proxyServer.setIdleConnectionTimeout(this.idleConnectionTimeoutSec);
        }
    }

    public void setRequestTimeout(int requestTimeout, TimeUnit timeUnit) {
        if (this.idleConnectionTimeoutSec == 0 || (long)this.idleConnectionTimeoutSec > TimeUnit.SECONDS.convert(requestTimeout, timeUnit)) {
            this.setIdleConnectionTimeout(requestTimeout, timeUnit);
        }
    }

    @Deprecated
    public void setConnectionTimeout(int connectionTimeoutMs) {
        this.setConnectTimeout(connectionTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void setSocketOperationTimeout(int readTimeoutMs) {
        this.setIdleConnectionTimeout(readTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void setRequestTimeout(int requestTimeoutMs) {
        this.setRequestTimeout(requestTimeoutMs, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void autoBasicAuthorization(String domain, String username, String password) {
        this.autoAuthorization(domain, username, password, AuthType.BASIC);
    }

    public void rewriteUrl(String pattern, String replace) {
        this.rewriteRules.add(new RewriteRule(pattern, replace));
    }

    public void rewriteUrls(Map<String, String> rewriteRules) {
        ArrayList<RewriteRule> newRules = new ArrayList<RewriteRule>(rewriteRules.size());
        for (Map.Entry<String, String> rewriteRule : rewriteRules.entrySet()) {
            RewriteRule newRule = new RewriteRule(rewriteRule.getKey(), rewriteRule.getValue());
            newRules.add(newRule);
        }
        this.rewriteRules = new CopyOnWriteArrayList(newRules);
    }

    public void clearRewriteRules() {
        this.rewriteRules.clear();
    }

    public void blacklistRequests(String pattern, int responseCode) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode));
    }

    public void blacklistRequests(String pattern, int responseCode, String method) {
        this.blacklistEntries.add(new BlacklistEntry(pattern, responseCode, method));
    }

    public void setBlacklist(Collection<BlacklistEntry> blacklist) {
        this.blacklistEntries = new CopyOnWriteArrayList<BlacklistEntry>(blacklist);
    }

    @Deprecated
    public List<BlacklistEntry> getBlacklistedRequests() {
        return ImmutableList.copyOf(this.blacklistEntries);
    }

    @Deprecated
    public Collection<BlacklistEntry> getBlacklistedUrls() {
        return this.getBlacklist();
    }

    public Collection<BlacklistEntry> getBlacklist() {
        return Collections.unmodifiableCollection(this.blacklistEntries);
    }

    public boolean isWhitelistEnabled() {
        return this.whitelist.get().isEnabled();
    }

    @Deprecated
    public List<Pattern> getWhitelistRequests() {
        return ImmutableList.copyOf((Collection)this.whitelist.get().getPatterns());
    }

    public Collection<String> getWhitelistUrls() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Pattern pattern : this.whitelist.get().getPatterns()) {
            builder.add((Object)pattern.pattern());
        }
        return builder.build();
    }

    @Deprecated
    public int getWhitelistResponseCode() {
        return this.getWhitelistStatusCode();
    }

    public int getWhitelistStatusCode() {
        return this.whitelist.get().getStatusCode();
    }

    public void clearBlacklist() {
        this.blacklistEntries.clear();
    }

    public void whitelistRequests(Collection<String> urlPatterns, int statusCode) {
        this.whitelist.set(new Whitelist(urlPatterns, statusCode));
    }

    public void addWhitelistPattern(String urlPattern) {
        boolean whitelistUpdated = false;
        while (!whitelistUpdated) {
            Whitelist currentWhitelist = this.whitelist.get();
            if (!currentWhitelist.isEnabled()) {
                throw new IllegalStateException("Whitelist is disabled. Cannot add patterns to a disabled whitelist.");
            }
            int statusCode = currentWhitelist.getStatusCode();
            ArrayList<String> newPatterns = new ArrayList<String>(currentWhitelist.getPatterns().size() + 1);
            for (Pattern pattern : currentWhitelist.getPatterns()) {
                newPatterns.add(pattern.pattern());
            }
            newPatterns.add(urlPattern);
            Whitelist newWhitelist = new Whitelist(newPatterns, statusCode);
            whitelistUpdated = this.whitelist.compareAndSet(currentWhitelist, newWhitelist);
        }
    }

    public void whitelistRequests(String[] patterns, int responseCode) {
        if (patterns == null || patterns.length == 0) {
            this.enableEmptyWhitelist(responseCode);
        } else {
            this.whitelistRequests(Arrays.asList(patterns), responseCode);
        }
    }

    public void enableEmptyWhitelist(int statusCode) {
        this.whitelist.set(new Whitelist(statusCode));
    }

    @Deprecated
    public void clearWhitelist() {
        this.disableWhitelist();
    }

    public void disableWhitelist() {
        this.whitelist.set(Whitelist.WHITELIST_DISABLED);
    }

    public void addHeader(String name, String value) {
        this.additionalHeaders.put(name, value);
    }

    public void removeHeader(String name) {
        this.additionalHeaders.remove(name);
    }

    public void removeAllHeaders() {
        this.additionalHeaders.clear();
    }

    public Map<String, String> getAllHeaders() {
        return ImmutableMap.copyOf(this.additionalHeaders);
    }

    public void setHostNameResolver(AdvancedHostResolver resolver) {
        this.delegatingResolver.setResolver(resolver);
    }

    public AdvancedHostResolver getHostNameResolver() {
        return this.delegatingResolver.getResolver();
    }

    @Deprecated
    public void clearDNSCache() {
        AdvancedHostResolver resolver = this.delegatingResolver.getResolver();
        resolver.clearDNSCache();
    }

    @Deprecated
    public void setDNSCacheTimeout(int timeout) {
        AdvancedHostResolver resolver = this.delegatingResolver.getResolver();
        resolver.setPositiveDNSCacheTimeout(timeout, TimeUnit.SECONDS);
        resolver.setNegativeDNSCacheTimeout(timeout, TimeUnit.SECONDS);
    }

    @Deprecated
    public void waitForNetworkTrafficToStop(long quietPeriodInMs, long timeoutInMs) {
        this.waitForQuiescence(quietPeriodInMs, timeoutInMs, TimeUnit.MILLISECONDS);
    }

    public boolean waitForQuiescence(long quietPeriod, long timeout, TimeUnit timeUnit) {
        return this.activityMonitor.waitForQuiescence(quietPeriod, timeout, timeUnit);
    }

    public void setChainedProxy(InetSocketAddress chainedProxyAddress) {
        this.upstreamProxyAddress = chainedProxyAddress;
    }

    public InetSocketAddress getChainedProxy() {
        return this.upstreamProxyAddress;
    }

    public void setChainedProxyManager(ChainedProxyManager chainedProxyManager) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot configure chained proxy manager after proxy has started.");
        }
        this.chainedProxyManager = chainedProxyManager;
    }

    public void setThreadPoolConfiguration(ThreadPoolConfiguration threadPoolConfiguration) {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot configure thread pool after proxy has started.");
        }
        this.threadPoolConfiguration = threadPoolConfiguration;
    }

    public void addFirstHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(0, filterFactory);
    }

    public void addLastHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(filterFactory);
    }

    public void addResponseFilter(ResponseFilter filter) {
        this.addLastHttpFilterFactory((HttpFiltersSource)new ResponseFilterAdapter.FilterSource(filter));
    }

    public void addRequestFilter(RequestFilter filter) {
        this.addFirstHttpFilterFactory((HttpFiltersSource)new RequestFilterAdapter.FilterSource(filter));
    }

    @Deprecated
    public void setOptions(Map<String, String> options) {
        if (options == null || options.isEmpty()) {
            return;
        }
        String httpProxy = options.get("httpProxy");
        if (httpProxy != null) {
            log.warn("Chained proxy support through setOptions is deprecated. Use setUpstreamProxy() to enable chained proxy support.");
            HostAndPort hostAndPort = HostAndPort.fromString((String)httpProxy);
            this.setChainedProxy(new InetSocketAddress(hostAndPort.getHostText(), hostAndPort.getPortOrDefault(80)));
        } else {
            if (this.errorOnUnsupportedOperation) {
                throw new UnsupportedOperationException("The LittleProxy-based implementation of BrowserMob Proxy does not support the setOptions method. Use the methods defined in the BrowserMobProxy interface to set connection parameters.");
            }
            log.warn("The LittleProxy-based implementation of BrowserMob Proxy does not support the setOptions method. Use the methods defined in the BrowserMobProxy interface to set connection parameters.");
        }
    }

    public Map<String, String> getRewriteRules() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (RewriteRule rewriteRule : this.rewriteRules) {
            builder.put((Object)rewriteRule.getPattern().pattern(), (Object)rewriteRule.getReplace());
        }
        return builder.build();
    }

    public void removeRewriteRule(String urlPattern) {
        for (RewriteRule rewriteRule : this.rewriteRules) {
            if (!rewriteRule.getPattern().pattern().equals(urlPattern)) continue;
            this.rewriteRules.remove(rewriteRule);
        }
    }

    @Deprecated
    public boolean isCaptureHeaders() {
        return this.harCaptureTypes.containsAll(CaptureType.getHeaderCaptureTypes());
    }

    @Deprecated
    public void setCaptureHeaders(boolean captureHeaders) {
        if (captureHeaders) {
            this.harCaptureTypes.addAll(CaptureType.getHeaderCaptureTypes());
        } else {
            this.harCaptureTypes.removeAll(CaptureType.getHeaderCaptureTypes());
        }
    }

    @Deprecated
    public boolean isCaptureContent() {
        return this.harCaptureTypes.containsAll(CaptureType.getNonBinaryContentCaptureTypes());
    }

    @Deprecated
    public void setCaptureContent(boolean captureContent) {
        if (captureContent) {
            this.harCaptureTypes.addAll(CaptureType.getAllContentCaptureTypes());
        } else {
            this.harCaptureTypes.removeAll(CaptureType.getAllContentCaptureTypes());
        }
    }

    @Deprecated
    public boolean isCaptureBinaryContent() {
        return this.harCaptureTypes.containsAll(CaptureType.getBinaryContentCaptureTypes());
    }

    @Deprecated
    public void setCaptureBinaryContent(boolean captureBinaryContent) {
        if (captureBinaryContent) {
            this.harCaptureTypes.addAll(CaptureType.getBinaryContentCaptureTypes());
        } else {
            this.harCaptureTypes.removeAll(CaptureType.getBinaryContentCaptureTypes());
        }
    }

    public void setErrorOnUnsupportedOperation(boolean errorOnUnsupportedOperation) {
        this.errorOnUnsupportedOperation = errorOnUnsupportedOperation;
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public HarPage getCurrentHarPage() {
        return this.currentHarPage;
    }

    public void addHttpFilterFactory(HttpFiltersSource filterFactory) {
        this.filterFactories.add(filterFactory);
    }

    public List<HttpFiltersSource> getFilterFactories() {
        return this.filterFactories;
    }

    public void setMitmDisabled(boolean mitmDisabled) throws IllegalStateException {
        if (this.isStarted()) {
            throw new IllegalStateException("Cannot disable MITM after the proxy has been started");
        }
        this.mitmDisabled = mitmDisabled;
    }

    public boolean isMitmDisabled() {
        return this.mitmDisabled;
    }

    protected void addBrowserMobFilters() {
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new ResolvedHostnameCacheFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new RegisterRequestFilter(originalRequest, ctx, BrowserMobProxyServer.this.activityMonitor);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpsOriginalHostCaptureFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new BlacklistFilter(originalRequest, ctx, BrowserMobProxyServer.this.getBlacklist());
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                Whitelist currentWhitelist = (Whitelist)BrowserMobProxyServer.this.whitelist.get();
                return new WhitelistFilter(originalRequest, ctx, BrowserMobProxyServer.this.isWhitelistEnabled(), currentWhitelist.getStatusCode(), currentWhitelist.getPatterns());
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new RewriteUrlFilter(originalRequest, ctx, BrowserMobProxyServer.this.rewriteRules);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new HttpsHostCaptureFilter(originalRequest, ctx);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return new AddHeadersFilter(originalRequest, BrowserMobProxyServer.this.additionalHeaders);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest) {
                return new LatencyFilter(originalRequest, BrowserMobProxyServer.this.latencyMs);
            }
        });
        this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

            public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                return new UnregisterRequestFilter(originalRequest, ctx, BrowserMobProxyServer.this.activityMonitor);
            }
        });
    }

    private int getMaximumRequestBufferSize() {
        int maxBufferSize = 0;
        for (HttpFiltersSource source : this.filterFactories) {
            int requestBufferSize = source.getMaximumRequestBufferSizeInBytes();
            if (requestBufferSize <= maxBufferSize) continue;
            maxBufferSize = requestBufferSize;
        }
        return maxBufferSize;
    }

    private int getMaximumResponseBufferSize() {
        int maxBufferSize = 0;
        for (HttpFiltersSource source : this.filterFactories) {
            int requestBufferSize = source.getMaximumResponseBufferSizeInBytes();
            if (requestBufferSize <= maxBufferSize) continue;
            maxBufferSize = requestBufferSize;
        }
        return maxBufferSize;
    }

    protected void addHarCaptureFilter() {
        if (this.harCaptureFilterEnabled.compareAndSet(false, true)) {
            this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

                public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                    Har har = BrowserMobProxyServer.this.getHar();
                    if (har != null && !ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                        return new HarCaptureFilter(originalRequest, ctx, har, BrowserMobProxyServer.this.getCurrentHarPage() == null ? null : BrowserMobProxyServer.this.getCurrentHarPage().getId(), BrowserMobProxyServer.this.getHarCaptureTypes());
                    }
                    return null;
                }
            });
            this.addHttpFilterFactory((HttpFiltersSource)new HttpFiltersSourceAdapter(){

                public HttpFilters filterRequest(HttpRequest originalRequest, ChannelHandlerContext ctx) {
                    Har har = BrowserMobProxyServer.this.getHar();
                    if (har != null && ProxyUtils.isCONNECT((HttpObject)originalRequest)) {
                        return new HttpConnectHarCaptureFilter(originalRequest, ctx, har, BrowserMobProxyServer.this.getCurrentHarPage() == null ? null : BrowserMobProxyServer.this.getCurrentHarPage().getId());
                    }
                    return null;
                }
            });
        }
    }

    @Deprecated
    private class StreamManagerLegacyAdapter
    extends StreamManager {
        private StreamManagerLegacyAdapter() {
            super(0L);
        }

        public void setDownstreamKbps(long downstreamKbps) {
            BrowserMobProxyServer.this.setDownstreamKbps(downstreamKbps);
        }

        public void setUpstreamKbps(long upstreamKbps) {
            BrowserMobProxyServer.this.setUpstreamKbps(upstreamKbps);
        }

        public void setLatency(long latency) {
            BrowserMobProxyServer.this.setLatency(latency);
        }

        public void setDownstreamMaxKB(long downstreamMaxKB) {
            BrowserMobProxyServer.this.setWriteLimitKbps(downstreamMaxKB);
        }

        public void setUpstreamMaxKB(long upstreamMaxKB) {
            BrowserMobProxyServer.this.setReadLimitKbps(upstreamMaxKB);
        }
    }
}

