/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix.software;

import java.io.Closeable;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.event.SimpleEvent;
import net.lecousin.framework.system.software.Processes;
import net.lecousin.framework.system.unix.jna.LibC;

public class ProcessesUnix
extends Processes {
    private static final Pattern DIGITS = Pattern.compile("\\d+");

    public int getCurrentProcessId() {
        return LibC.INSTANCE.getpid();
    }

    public List<Integer> listProcessesIds() {
        File dir = new File("/proc");
        File[] files = null;
        if (dir.exists() && dir.isDirectory()) {
            files = dir.listFiles();
        }
        if (files != null) {
            ArrayList<Integer> list = new ArrayList<Integer>(files.length);
            for (File f : files) {
                String name = f.getName();
                if (!DIGITS.matcher(name).matches()) continue;
                list.add(Integer.parseInt(name));
            }
            return list;
        }
        return new ArrayList<Integer>(0);
    }

    public void killProcess(int id) throws Exception {
    }

    public long getProcessCPUTimeNano(int id) {
        return 0L;
    }

    public SeparateProcess executeCommand(String[] command, boolean elevated) throws Exception {
        ProcessBuilder builder = new ProcessBuilder(command);
        Process p = builder.start();
        return new SeparateProcess(p, Arrays.toString(command));
    }

    private static class SeparateProcess
    implements Processes.SeparateProcess,
    Closeable {
        private Process p;
        private Thread thread;
        private Integer exitCode = null;
        private SimpleEvent terminated = new SimpleEvent();

        private SeparateProcess(Process process, String command) {
            this.p = process;
            Application app = LCCore.getApplication();
            this.thread = app.getThreadFactory().newThread(new WaitFor());
            this.thread.setName("Wait for process to terminate: " + command);
            this.thread.start();
            app.toClose((Closeable)this);
        }

        public int getExitCode() throws IllegalThreadStateException {
            if (this.exitCode == null) {
                throw new IllegalThreadStateException();
            }
            return this.exitCode;
        }

        public void kill() {
            this.p.destroyForcibly();
            LCCore.getApplication().closed((Closeable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(Runnable listener) {
            SimpleEvent simpleEvent = this.terminated;
            synchronized (simpleEvent) {
                if (this.exitCode == null) {
                    this.terminated.addListener(listener);
                    return;
                }
            }
            listener.run();
        }

        @Override
        public void close() {
            if (this.exitCode != null) {
                return;
            }
            this.kill();
        }

        private class WaitFor
        implements Runnable {
            private WaitFor() {
            }

            @Override
            public void run() {
                try {
                    SeparateProcess.this.exitCode = SeparateProcess.this.p.waitFor();
                    SeparateProcess.this.terminated.fire();
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    if (SeparateProcess.this.p.isAlive()) {
                        SeparateProcess.this.p.destroyForcibly();
                    }
                    LCCore.getApplication().closed((Closeable)SeparateProcess.this);
                }
            }
        }
    }
}

