/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix.jna;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.util.Arrays;
import java.util.List;

public interface LibC
extends com.sun.jna.platform.unix.LibC {
    public static final LibC INSTANCE = (LibC)Native.loadLibrary((String)"c", LibC.class);
    public static final int O_RDONLY = 0;
    public static final int O_NONBLOCK = 2048;
    public static final short POLLPRI = 2;
    public static final short POLLERR = 8;

    public int getpid();

    public int open(String var1, int var2);

    public int close(int var1);

    public int select(int var1, FDSet var2, FDSet var3, FDSet var4, TimeVal var5);

    public int poll(PollFD[] var1, int var2, int var3);

    public static class FDSet
    extends Structure {
        private static final int NFBBITS = NativeLong.SIZE * 8;
        private static final int fd_count = 1024;
        public NativeLong[] fd_array = new NativeLong[(1024 + NFBBITS - 1) / NFBBITS];

        public FDSet() {
            int i = 0;
            while (i < this.fd_array.length) {
                this.fd_array[i] = new NativeLong();
                ++i;
            }
        }

        protected List getFieldOrder() {
            return Arrays.asList("fd_array");
        }

        public void FD_SET(int fd) {
            this.fd_array[fd / NFBBITS].setValue(this.fd_array[fd / NFBBITS].longValue() | 1L << fd % NFBBITS);
        }

        public boolean FD_ISSET(int fd) {
            return (this.fd_array[fd / NFBBITS].longValue() & 1L << fd % NFBBITS) != 0L;
        }

        public void FD_ZERO() {
            NativeLong[] nativeLongArray = this.fd_array;
            int n = this.fd_array.length;
            int n2 = 0;
            while (n2 < n) {
                NativeLong fd = nativeLongArray[n2];
                fd.setValue(0L);
                ++n2;
            }
        }

        public void FD_CLR(int fd) {
            this.fd_array[fd / NFBBITS].setValue(this.fd_array[fd / NFBBITS].longValue() & (1L << fd % NFBBITS ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static class PollFD
    extends Structure {
        public int fd;
        public short events;
        public short revents;

        public PollFD(int fd, short events, short revents) {
            this.fd = fd;
            this.events = events;
            this.revents = revents;
        }

        protected List getFieldOrder() {
            return Arrays.asList("fd", "events", "revents");
        }
    }

    public static class TimeVal
    extends Structure {
        public NativeLong tv_sec;
        public NativeLong tv_usec;

        public TimeVal(long sec, long usec) {
            this.tv_sec = new NativeLong(sec);
            this.tv_usec = new NativeLong(usec);
        }

        protected List getFieldOrder() {
            return Arrays.asList("tv_sec", "tv_usec");
        }
    }
}

