/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix.hardware;

import java.io.File;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.progress.WorkProgressImpl;
import net.lecousin.framework.system.LCSystem;
import net.lecousin.framework.system.hardware.DiskPartition;
import net.lecousin.framework.system.hardware.DiskPartitionsUtil;
import net.lecousin.framework.system.hardware.Drive;
import net.lecousin.framework.system.hardware.Drives;
import net.lecousin.framework.system.hardware.PhysicalDrive;
import net.lecousin.framework.system.unix.hardware.PhysicalDriveUnix;
import net.lecousin.framework.system.unix.jna.JnaInstances;
import net.lecousin.framework.system.unix.jna.LibC;
import net.lecousin.framework.system.unix.jna.linux.Udev;
import net.lecousin.framework.util.AsyncCloseable;

public class DrivesUnixUdev
extends Drives {
    private WorkProgress init = null;
    private List<Drive> drives = new ArrayList<Drive>();
    private List<Drives.DriveListener> listeners = new ArrayList<Drives.DriveListener>();

    public WorkProgress initialize() {
        if (this.init != null) {
            return this.init;
        }
        this.init = new WorkProgressImpl(100000L, "Loading drives information");
        new Thread("Initializing Drives Information"){

            @Override
            public void run() {
                DrivesUnixUdev.this.initDrives(DrivesUnixUdev.this.init);
                LCSystem.log.info("Drives information initialized");
                DrivesUnixUdev.this.init.done();
            }
        }.start();
        return this.init;
    }

    public List<Drive> getDrives() {
        return new ArrayList<Drive>(this.drives);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getDrivesAndListen(Drives.DriveListener listener) {
        List<Drive> list = this.drives;
        synchronized (list) {
            for (Drive d : this.drives) {
                listener.newDrive(d);
            }
            List<Drives.DriveListener> list2 = this.listeners;
            synchronized (list2) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDriveListener(Drives.DriveListener listener) {
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDriveListener(Drives.DriveListener listener) {
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> T openReadOnly(PhysicalDrive drive, byte priority) {
        return (T)new FileIO.ReadOnly(new File((String)drive.getOSId()), priority);
    }

    public <T extends IO.Writable.Seekable & IO.KnownSize> T openWriteOnly(PhysicalDrive drive, byte priority) {
        return (T)new FileIO.WriteOnly(new File((String)drive.getOSId()), priority);
    }

    public <T extends IO.Readable.Seekable & IO.KnownSize> T openReadWrite(PhysicalDrive drive, byte priority) {
        return (T)new FileIO.ReadWrite(new File((String)drive.getOSId()), priority);
    }

    private void initDrives(WorkProgress progress) {
        List<String[]> mountsLines = DrivesUnixUdev.readMounts();
        Udev udev = JnaInstances.udev;
        Udev.UdevHandle handle = udev.udev_new();
        Udev.UdevEnumerate enumerate = udev.udev_enumerate_new(handle);
        udev.udev_enumerate_add_match_subsystem(enumerate, "block");
        udev.udev_enumerate_scan_devices(enumerate);
        Udev.UdevListEntry entry = udev.udev_enumerate_get_list_entry(enumerate);
        while (entry != null) {
            block10: {
                String name = udev.udev_list_entry_get_name(entry);
                Udev.UdevDevice device = null;
                try {
                    try {
                        device = udev.udev_device_new_from_syspath(handle, name);
                        this.newDevice(udev, device, mountsLines);
                    }
                    catch (Throwable t) {
                        LCSystem.log.error("Error reading device", t);
                        if (device != null) {
                            udev.udev_device_unref(device);
                        }
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    if (device != null) {
                        udev.udev_device_unref(device);
                    }
                    throw throwable;
                }
                if (device != null) {
                    udev.udev_device_unref(device);
                }
            }
            entry = udev.udev_list_entry_get_next(entry);
        }
        udev.udev_enumerate_unref(enumerate);
        this.addAdditionalPartitions(mountsLines);
        MonitorUdev monitor = new MonitorUdev(handle);
        monitor.start();
        LCCore.get().toClose((AsyncCloseable)monitor);
        File f = new File("/proc/self/mounts");
        if (f.exists()) {
            MonitorMounts m = new MonitorMounts();
            m.start();
            LCCore.get().toClose((AsyncCloseable)m);
        }
    }

    private void newDevice(Udev udev, Udev.UdevDevice device, List<String[]> mountsLines) {
        String devnode = udev.udev_device_get_devnode(device);
        String devtype = udev.udev_device_get_devtype(device);
        if ("disk".equals(devtype)) {
            if (!devnode.startsWith("/dev/loop") && !devnode.startsWith("/dev/ram")) {
                this.newDisk(udev, device);
            }
        } else if ("partition".equals(devtype)) {
            this.newPartition(udev, device, mountsLines);
        }
    }

    private void newDisk(Udev udev, Udev.UdevDevice device) {
        String devnode = udev.udev_device_get_devnode(device);
        String devpath = udev.udev_device_get_property_value(device, "DEVPATH");
        String model = udev.udev_device_get_property_value(device, "ID_MODEL");
        String serial = udev.udev_device_get_property_value(device, "ID_SERIAL_SHORT");
        String revision = udev.udev_device_get_property_value(device, "ID_REVISION");
        String type = udev.udev_device_get_property_value(device, "ID_TYPE");
        String bus = udev.udev_device_get_property_value(device, "ID_BUS");
        String removable = udev.udev_device_get_sysattr_value(device, "removable");
        String sizeStr = udev.udev_device_get_sysattr_value(device, "size");
        BigInteger size = null;
        if (sizeStr != null) {
            try {
                size = new BigInteger(sizeStr);
                size = size.multiply(BigInteger.valueOf(512L));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        PhysicalDriveUnix drive = new PhysicalDriveUnix();
        drive.devpath = devpath;
        drive.osId = devnode;
        drive.model = model;
        drive.version = revision;
        drive.serial = serial;
        if ("disk".equals(type)) {
            drive.type = PhysicalDrive.Type.HARDDISK;
        } else if ("cd".equals(type)) {
            drive.type = PhysicalDrive.Type.CDROM;
        } else {
            LCSystem.log.warn("Unknown device type '" + type + "' for " + devnode);
            drive.type = PhysicalDrive.Type.UNKNOWN;
        }
        if ("ata".equals(bus)) {
            drive.itype = PhysicalDrive.InterfaceType.ATA;
        } else if ("usb".equals(bus)) {
            drive.itype = PhysicalDrive.InterfaceType.USB;
        } else {
            LCSystem.log.warn("Unknown bus type '" + bus + "' for " + devnode);
            drive.itype = PhysicalDrive.InterfaceType.Unknown;
        }
        drive.removable = "1".equals(removable);
        drive.size = size;
        this.readPartitions(drive);
        this.signalNewDrive((Drive)drive);
    }

    private void newPartition(Udev udev, Udev.UdevDevice device, List<String[]> mountsLines) {
        String devpath = udev.udev_device_get_property_value(device, "DEVPATH");
        PhysicalDriveUnix drive = null;
        for (Drive d : this.drives) {
            if (!(d instanceof PhysicalDriveUnix)) continue;
            PhysicalDriveUnix pd = (PhysicalDriveUnix)d;
            if (!devpath.startsWith(String.valueOf(pd.devpath) + '/')) continue;
            drive = pd;
            break;
        }
        if (drive == null) {
            LCSystem.log.warn("Partition on unknown drive: " + devpath);
        } else {
            DiskPartition p2;
            String osId = udev.udev_device_get_devnode(device);
            boolean found = false;
            for (DiskPartition p2 : drive.partitions) {
                if (p2.OSID == null || !p2.OSID.equals(osId)) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
            p2 = new DiskPartition();
            p2.drive = drive;
            p2.OSID = osId;
            String s = udev.udev_device_get_property_value(device, "PARTN");
            if (s != null) {
                try {
                    p2.index = Integer.parseInt(s);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            DrivesUnixUdev.addMountPoint(p2, mountsLines);
            drive.partitions.add(p2);
            this.signalNewPartition(p2);
        }
    }

    private void deviceRemoved(Udev udev, Udev.UdevDevice device) {
        String devnode = udev.udev_device_get_devnode(device);
        String devtype = udev.udev_device_get_devtype(device);
        if ("disk".equals(devtype)) {
            if (!devnode.startsWith("/dev/loop") && !devnode.startsWith("/dev/ram")) {
                this.diskRemoved(udev, device);
            }
        } else if ("partition".equals(devtype)) {
            this.partitionRemoved(udev, device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void diskRemoved(Udev udev, Udev.UdevDevice device) {
        ArrayList<Drives.DriveListener> listeners;
        Object it;
        String devpath = udev.udev_device_get_property_value(device, "DEVPATH");
        Drive drive = null;
        List<Drive> list = this.drives;
        synchronized (list) {
            it = this.drives.iterator();
            while (it.hasNext()) {
                Drive d = it.next();
                if (!(d instanceof PhysicalDriveUnix) || !((PhysicalDriveUnix)d).devpath.equals(devpath)) continue;
                it.remove();
                drive = d;
                break;
            }
        }
        if (drive == null) {
            return;
        }
        LCSystem.log.info("Drive removed: " + drive);
        it = this.listeners;
        synchronized (it) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        for (Drives.DriveListener listener : listeners) {
            listener.driveRemoved(drive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void partitionRemoved(Udev udev, Udev.UdevDevice device) {
        ArrayList<Drives.DriveListener> listeners;
        Object d2;
        String devnode = udev.udev_device_get_devnode(device);
        DiskPartition part = null;
        List<Drive> list = this.drives;
        synchronized (list) {
            for (Object d2 : this.drives) {
                if (!(d2 instanceof PhysicalDriveUnix)) continue;
                Iterator<DiskPartition> it = ((PhysicalDriveUnix)d2).partitions.iterator();
                while (it.hasNext()) {
                    DiskPartition p = it.next();
                    if (p.OSID == null || !p.OSID.equals(devnode)) continue;
                    part = p;
                    it.remove();
                    break;
                }
                if (part != null) break;
            }
        }
        if (part == null) {
            return;
        }
        LCSystem.log.info("Partition removed: " + part);
        d2 = this.listeners;
        synchronized (d2) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        for (Drives.DriveListener listener : listeners) {
            listener.partitionRemoved(part);
        }
    }

    private void readPartitions(PhysicalDriveUnix drive) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Object stream = this.openReadOnly(drive, (byte)2);){
                ArrayList partitions = new ArrayList();
                DiskPartitionsUtil.readPartitionTable((IO.Readable.Seekable)((IO.Readable.Seekable)stream), partitions);
                for (DiskPartition p : partitions) {
                    boolean found = false;
                    for (DiskPartition dp : drive.partitions) {
                        if (dp.start != p.start) continue;
                        found = true;
                        dp.partitionSlotIndex = p.partitionSlotIndex;
                        dp.nbSectors = p.nbSectors;
                        dp.startCylinder = p.startCylinder;
                        dp.startHead = p.startHead;
                        dp.startSector = dp.startSector;
                        dp.endCylinder = p.endCylinder;
                        dp.endHead = p.endHead;
                        dp.endSector = p.endSector;
                        dp.lba = p.lba;
                        break;
                    }
                    if (found) continue;
                    p.drive = drive;
                    drive.partitions.add(p);
                    this.signalNewPartition(p);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNewDrive(Drive drive) {
        ArrayList<Drives.DriveListener> listeners;
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        list = this.drives;
        synchronized (list) {
            this.drives.add(drive);
        }
        DrivesUnixUdev.logDrive(drive);
        for (Drives.DriveListener listener : listeners) {
            listener.newDrive(drive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalNewPartition(DiskPartition p) {
        ArrayList<Drives.DriveListener> listeners;
        List<Drives.DriveListener> list = this.listeners;
        synchronized (list) {
            listeners = new ArrayList<Drives.DriveListener>(this.listeners);
        }
        DrivesUnixUdev.logPartition(p);
        for (Drives.DriveListener listener : listeners) {
            listener.newPartition(p);
        }
    }

    private static List<String[]> readMounts() {
        File f = new File("/proc/self/mounts");
        if (!f.exists()) {
            return null;
        }
        Pattern whitespaces = Pattern.compile("\\s+");
        try {
            List<String> lines = Files.readAllLines(f.toPath(), StandardCharsets.UTF_8);
            LinkedList<String[]> result = new LinkedList<String[]>();
            for (String line : lines) {
                String[] tokens = whitespaces.split(line = line.trim());
                if (tokens.length < 3 || !tokens[0].startsWith("/dev/")) continue;
                result.add(tokens);
            }
            return result;
        }
        catch (Throwable t) {
            LCSystem.log.error("Unable to parse /proc/self/mounts", t);
            return null;
        }
    }

    private static void addMountPoint(DiskPartition dp, List<String[]> mountsLines) {
        if (mountsLines == null) {
            return;
        }
        for (String[] tokens : mountsLines) {
            if (!dp.OSID.equals(tokens[0])) continue;
            dp.mountPoint = new File(tokens[1]);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAdditionalPartitions(List<String[]> mountsLines) {
        if (mountsLines == null) {
            return;
        }
        for (String[] tokens : mountsLines) {
            PhysicalDriveUnix dr = null;
            DiskPartition newMountPoint = null;
            List<Drive> list = this.drives;
            synchronized (list) {
                for (Drive d : this.drives) {
                    if (!(d instanceof PhysicalDriveUnix)) continue;
                    PhysicalDriveUnix drive = (PhysicalDriveUnix)d;
                    if (!tokens[0].startsWith(drive.osId)) continue;
                    boolean found = false;
                    for (DiskPartition p : drive.partitions) {
                        if (!p.OSID.equals(tokens[0])) continue;
                        found = true;
                        if (p.mountPoint != null) break;
                        p.mountPoint = new File(tokens[1]);
                        newMountPoint = p;
                        break;
                    }
                    if (found) break;
                    dr = drive;
                    break;
                }
            }
            if (dr != null) {
                DiskPartition dp = new DiskPartition();
                dp.mountPoint = new File(tokens[1]);
                dp.drive = dr;
                dp.OSID = tokens[0];
                dr.partitions.add(dp);
                this.signalNewPartition(dp);
                continue;
            }
            if (newMountPoint == null) continue;
            this.signalNewPartition(newMountPoint);
        }
    }

    private static void logDrive(Drive drive) {
        if (drive instanceof PhysicalDriveUnix) {
            DrivesUnixUdev.logPhysicalDrive((PhysicalDriveUnix)drive);
        }
    }

    private static void logPhysicalDrive(PhysicalDriveUnix drive) {
        StringBuilder s = new StringBuilder(128);
        s.append("Drive detected: ");
        s.append(drive.osId);
        s.append(" (").append(drive.toString()).append(")");
        s.append(" type ").append(drive.type).append(" bus ").append(drive.itype);
        LCSystem.log.info(s.toString());
    }

    private static void logPartition(DiskPartition p) {
        StringBuilder s = new StringBuilder(128);
        s.append("Partition detected: ");
        s.append(p.OSID);
        File m = p.mountPoint;
        if (m == null) {
            s.append(" not mounted");
        } else {
            s.append(" mounted on ").append(m.getAbsolutePath());
        }
        s.append(" on drive ");
        s.append(p.drive.toString());
        LCSystem.log.info(s.toString());
    }

    static /* synthetic */ List access$0() {
        return DrivesUnixUdev.readMounts();
    }

    static /* synthetic */ void access$1(DrivesUnixUdev drivesUnixUdev, Udev udev, Udev.UdevDevice udevDevice, List list) {
        drivesUnixUdev.newDevice(udev, udevDevice, list);
    }

    static /* synthetic */ void access$2(DrivesUnixUdev drivesUnixUdev, List list) {
        drivesUnixUdev.addAdditionalPartitions(list);
    }

    static /* synthetic */ void access$3(DrivesUnixUdev drivesUnixUdev, Udev udev, Udev.UdevDevice udevDevice) {
        drivesUnixUdev.deviceRemoved(udev, udevDevice);
    }

    private class MonitorMounts
    extends Thread
    implements AsyncCloseable<Exception> {
        private SynchronizationPoint<Exception> closing;

        public MonitorMounts() {
            super("Mount points Monitor");
            this.closing = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            var3_1 = DrivesUnixUdev.class;
            synchronized (DrivesUnixUdev.class) {
                fd = LibC.INSTANCE.open("/proc/self/mounts", 0);
                pollfd = new LibC.PollFD(fd, 10, 0);
                pfd = new LibC.PollFD[]{pollfd};
                // ** MonitorExit[var3_1] (shouldn't be in output)
                if (true) ** GOTO lbl21
                do {
                    if ((ret = LibC.INSTANCE.poll(pfd, 1, 2000)) <= 0) continue;
                    try {
                        LCSystem.log.info("Mount points file changed.");
                        mounts = DrivesUnixUdev.access$0();
                        DrivesUnixUdev.access$2(DrivesUnixUdev.this, mounts);
                    }
                    catch (Throwable t) {
                        LCSystem.log.error("Error analyzing mount points", t);
                    }
lbl21:
                    // 4 sources

                } while (this.closing == null);
                LibC.INSTANCE.close(fd);
                this.closing.unblock();
                return;
            }
        }

        public ISynchronizationPoint<Exception> closeAsync() {
            if (this.closing != null) {
                return this.closing;
            }
            this.closing = new SynchronizationPoint();
            return this.closing;
        }
    }

    private class MonitorUdev
    extends Thread
    implements AsyncCloseable<Exception> {
        private Udev.UdevHandle handle;
        private SynchronizationPoint<Exception> closing;

        public MonitorUdev(Udev.UdevHandle handle) {
            super("Udev Monitor");
            this.closing = null;
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            udev = JnaInstances.udev;
            monitor = udev.udev_monitor_new_from_netlink(this.handle, "udev");
            udev.udev_monitor_filter_add_match_subsystem_devtype(monitor, "block", null);
            udev.udev_monitor_enable_receiving(monitor);
            fd = udev.udev_monitor_get_fd(monitor);
            var6_4 = DrivesUnixUdev.class;
            // MONITORENTER : net.lecousin.framework.system.unix.hardware.DrivesUnixUdev.class
            fds = new LibC.FDSet();
            fds.FD_ZERO();
            fds.FD_SET(fd);
            tv = new LibC.TimeVal(2L, 0L);
            // MONITOREXIT : var6_4
            if (true) ** GOTO lbl56
            do {
                block13: {
                    var6_5 = DrivesUnixUdev.class;
                    // MONITORENTER : net.lecousin.framework.system.unix.hardware.DrivesUnixUdev.class
                    fds = new LibC.FDSet();
                    fds.FD_ZERO();
                    fds.FD_SET(fd);
                    tv = new LibC.TimeVal(2L, 0L);
                    // MONITOREXIT : var6_5
                    ret = LibC.INSTANCE.select(fd + 1, fds, null, null, tv);
                    if (ret <= 0) continue;
                    device = udev.udev_monitor_receive_device(monitor);
                    try {
                        try {
                            action = udev.udev_device_get_property_value(device, "ACTION");
                            if ("add".equals(action)) {
                                mounts = DrivesUnixUdev.access$0();
                                DrivesUnixUdev.access$1(DrivesUnixUdev.this, udev, device, mounts);
                                DrivesUnixUdev.access$2(DrivesUnixUdev.this, mounts);
                                break block13;
                            }
                            if ("remove".equals(action)) {
                                DrivesUnixUdev.access$3(DrivesUnixUdev.this, udev, device);
                            }
                        }
                        catch (Throwable t) {
                            LCSystem.log.error("Error analyzing device", t);
                            udev.udev_device_unref(device);
                            continue;
                        }
                    }
                    catch (Throwable var10_13) {
                        udev.udev_device_unref(device);
                        throw var10_13;
                    }
                }
                udev.udev_device_unref(device);
lbl56:
                // 4 sources

            } while (this.closing == null);
            udev.udev_monitor_unref(monitor);
            udev.udev_unref(this.handle);
            this.closing.unblock();
        }

        public ISynchronizationPoint<Exception> closeAsync() {
            if (this.closing != null) {
                return this.closing;
            }
            this.closing = new SynchronizationPoint();
            return this.closing;
        }
    }
}

