/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.system.unix;

import com.sun.jna.Native;
import com.sun.jna.Platform;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.system.LCSystem;
import net.lecousin.framework.system.hardware.Drives;
import net.lecousin.framework.system.unix.hardware.DrivesMac;
import net.lecousin.framework.system.unix.hardware.DrivesUnixUdev;
import net.lecousin.framework.system.unix.jna.JnaInstances;
import net.lecousin.framework.system.unix.jna.linux.Udev;
import net.lecousin.framework.system.unix.jna.mac.CoreFoundation;
import net.lecousin.framework.system.unix.jna.mac.DiskArbitration;
import net.lecousin.framework.system.unix.jna.mac.IOKit;
import net.lecousin.framework.system.unix.jna.mac.RunLoopThread;
import net.lecousin.framework.system.unix.jna.mac.SystemB;

public class Init
implements CustomExtensionPoint {
    public Init() {
        if (Platform.isMac()) {
            try {
                JnaInstances.diskArbitration = (DiskArbitration)Native.loadLibrary((String)"DiskArbitration", DiskArbitration.class);
                JnaInstances.coreFoundation = (CoreFoundation)Native.loadLibrary((String)"CoreFoundation", CoreFoundation.class);
                JnaInstances.ALLOCATOR = JnaInstances.coreFoundation.CFAllocatorGetDefault();
                JnaInstances.ioKit = (IOKit)Native.loadLibrary((String)"IOKit", IOKit.class);
                JnaInstances.systemB = (SystemB)Native.loadLibrary((String)"System", SystemB.class);
                RunLoopThread.init();
                Drives.setInstance((Drives)new DrivesMac());
            }
            catch (Throwable t) {
                LCSystem.log.error("Error loading native libraries for Mac", t);
            }
        } else {
            try {
                JnaInstances.udev = (Udev)Native.loadLibrary((String)"udev", Udev.class);
                Drives.setInstance((Drives)new DrivesUnixUdev());
            }
            catch (Throwable t) {
                LCSystem.log.error("Error loading native libraries for Linux", t);
            }
        }
    }
}

