/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.util.ObjectUtil;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.xml.dom.XMLDocument;
import net.lecousin.framework.xml.dom.XMLElement;
import net.lecousin.framework.xml.dom.XMLNamedNodeMap;
import net.lecousin.framework.xml.dom.XMLNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public abstract class XMLNode
implements Node {
    protected XMLDocument doc;
    protected XMLNode parent = null;
    protected Map<String, Pair<Object, UserDataHandler>> userData = null;

    protected XMLNode(XMLDocument doc) {
        this.doc = doc;
    }

    @Override
    public XMLDocument getOwnerDocument() {
        return this.doc;
    }

    protected void setParent(XMLNode parent) {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = parent;
    }

    @Override
    public Node getParentNode() {
        return this.parent;
    }

    public boolean isAncestor(XMLNode node) {
        return node == this.parent || this.parent != null && this.parent.isAncestor(node);
    }

    @Override
    public String getNodeValue() {
        return null;
    }

    @Override
    public void setNodeValue(String nodeValue) {
    }

    @Override
    public void setPrefix(String prefix) {
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getLocalName() {
        return null;
    }

    @Override
    public String getNamespaceURI() {
        return null;
    }

    @Override
    public Node getFirstChild() {
        return null;
    }

    @Override
    public Node getLastChild() {
        return null;
    }

    @Override
    public boolean hasChildNodes() {
        return false;
    }

    @Override
    public NodeList getChildNodes() {
        return new XMLNodeList(null);
    }

    @Override
    public XMLNode getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof XMLElement)) {
            return null;
        }
        XMLElement p = (XMLElement)this.parent;
        int i = p.children.indexOf(this);
        if (i <= 0) {
            return null;
        }
        return p.children.get(i - 1);
    }

    @Override
    public XMLNode getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        if (!(this.parent instanceof XMLElement)) {
            return null;
        }
        XMLElement p = (XMLElement)this.parent;
        int i = p.children.indexOf(this);
        if (i < 0 || i == p.children.size() - 1) {
            return null;
        }
        return p.children.get(i + 1);
    }

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(9, "Operation not allowed");
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(9, "Operation not allowed");
    }

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(9, "Operation not allowed");
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(9, "Operation not allowed");
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookupPrefix(namespaceURI);
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        if (this.parent == null) {
            return false;
        }
        return this.parent.isDefaultNamespace(namespaceURI);
    }

    @Override
    public String lookupNamespaceURI(String prefix) {
        if (this.parent == null) {
            return null;
        }
        return this.parent.lookupNamespaceURI(prefix);
    }

    @Override
    public boolean hasAttributes() {
        return false;
    }

    @Override
    public NamedNodeMap getAttributes() {
        return new XMLNamedNodeMap(null);
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public boolean isSupported(String feature, String version) {
        return false;
    }

    @Override
    public Object getFeature(String feature, String version) {
        return null;
    }

    @Override
    public boolean isSameNode(Node other) {
        return other == this;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (arg == null) {
            return false;
        }
        if (!(arg instanceof XMLNode)) {
            return false;
        }
        XMLNode n = (XMLNode)arg;
        if (!this.getClass().equals(n.getClass())) {
            return false;
        }
        if (!ObjectUtil.equalsOrNull(this.getNodeName(), n.getNodeName())) {
            return false;
        }
        if (!ObjectUtil.equalsOrNull(this.getNodeValue(), n.getNodeValue())) {
            return false;
        }
        if (!ObjectUtil.equalsOrNull(this.getLocalName(), n.getLocalName())) {
            return false;
        }
        if (!ObjectUtil.equalsOrNull(this.getPrefix(), n.getPrefix())) {
            return false;
        }
        if (!ObjectUtil.equalsOrNull(this.getNamespaceURI(), n.getNamespaceURI())) {
            return false;
        }
        NamedNodeMap map1 = this.getAttributes();
        NamedNodeMap map2 = n.getAttributes();
        if (map1 == null) {
            return map2 == null;
        }
        if (map2 == null) {
            return false;
        }
        if (map1.getLength() != map2.getLength()) {
            return false;
        }
        for (int i = 0; i < map1.getLength(); ++i) {
            Node item = map1.item(i);
            if (map2.getNamedItemNS(item.getNamespaceURI(), item.getLocalName()) != null) continue;
            return false;
        }
        NodeList list1 = this.getChildNodes();
        NodeList list2 = n.getChildNodes();
        if (list1 == null) {
            return list2 == null;
        }
        if (list2 == null) {
            return false;
        }
        if (list1.getLength() != list2.getLength()) {
            return false;
        }
        for (int i = 0; i < list1.getLength(); ++i) {
            Node item = list1.item(i);
            boolean found = false;
            for (int j = 0; j < list2.getLength(); ++j) {
                if (!item.isEqualNode(list2.item(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        Pair<Object, UserDataHandler> p = this.userData.get(key);
        if (p == null) {
            return null;
        }
        return p.getValue1();
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        Pair<Object, UserDataHandler> p;
        if (this.userData == null) {
            this.userData = new HashMap<String, Pair<Object, UserDataHandler>>();
        }
        return (p = this.userData.put(key, new Pair<Object, UserDataHandler>(data, handler))) != null ? p.getValue1() : null;
    }

    protected void cloned(XMLNode clone) {
        if (this.userData == null) {
            return;
        }
        for (Map.Entry<String, Pair<Object, UserDataHandler>> p : this.userData.entrySet()) {
            UserDataHandler h = p.getValue().getValue2();
            if (h == null) continue;
            h.handle((short)1, p.getKey(), p.getValue().getValue1(), this, clone);
        }
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        throw new DOMException(9, "compareDocumentPosition not supported");
    }

    @Override
    public void normalize() {
    }
}

