/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.xml.dom;

import java.util.List;
import net.lecousin.framework.util.ObjectUtil;
import net.lecousin.framework.xml.dom.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLNamedNodeMap
implements NamedNodeMap {
    protected List<? extends XMLNode> nodes;

    public XMLNamedNodeMap(List<? extends XMLNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public XMLNode getNamedItem(String name) {
        if (this.nodes == null || name == null) {
            return null;
        }
        for (XMLNode xMLNode : this.nodes) {
            if (!name.equals(xMLNode.getNodeName())) continue;
            return xMLNode;
        }
        return null;
    }

    @Override
    public XMLNode setNamedItem(Node arg) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public Node removeNamedItem(String name) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public XMLNode item(int index) {
        if (this.nodes == null || index < 0 || index >= this.nodes.size()) {
            return null;
        }
        return this.nodes.get(index);
    }

    @Override
    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    @Override
    public Node getNamedItemNS(String namespaceURI, String localName) throws DOMException {
        if (this.nodes == null || localName == null) {
            return null;
        }
        for (XMLNode xMLNode : this.nodes) {
            if (!localName.equals(xMLNode.getLocalName()) || !ObjectUtil.equalsOrNull(namespaceURI, xMLNode.getNamespaceURI())) continue;
            return xMLNode;
        }
        return null;
    }

    @Override
    public Node setNamedItemNS(Node arg) throws DOMException {
        throw new DOMException(9, "Not supported");
    }

    @Override
    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, "Not supported");
    }
}

