/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.IString;
import net.lecousin.framework.util.Provider;
import net.lecousin.framework.util.UnprotectedString;

public class UnprotectedStringBuffer
implements IString {
    private UnprotectedString[] strings;
    private int lastUsed;

    public UnprotectedStringBuffer() {
        this.strings = null;
        this.lastUsed = 0;
    }

    public UnprotectedStringBuffer(UnprotectedString string) {
        this.strings = new UnprotectedString[8];
        this.strings[0] = string;
        this.lastUsed = 0;
    }

    public UnprotectedStringBuffer(Collection<UnprotectedString> strings) {
        this.strings = new UnprotectedString[strings.size() + 8];
        int i = 0;
        for (UnprotectedString s : strings) {
            this.strings[i++] = s;
        }
        this.lastUsed = i - 1;
    }

    public UnprotectedStringBuffer(String s) {
        this.strings = new UnprotectedString[1];
        this.lastUsed = 0;
        this.strings[0] = new UnprotectedString(s);
    }

    public UnprotectedStringBuffer(CharSequence s) {
        this.strings = new UnprotectedString[1];
        this.lastUsed = 0;
        this.strings[0] = new UnprotectedString(s);
    }

    public UnprotectedStringBuffer(IString s) {
        this.strings = new UnprotectedString[1];
        this.lastUsed = 0;
        this.strings[0] = new UnprotectedString(s);
    }

    public int getNbUsableUnprotectedStrings() {
        if (this.strings == null) {
            return 0;
        }
        return this.lastUsed + 1;
    }

    public UnprotectedString getUnprotectedString(int index) {
        return this.strings[index];
    }

    @Override
    public int length() {
        if (this.strings == null) {
            return 0;
        }
        int len = 0;
        for (int i = this.lastUsed; i >= 0; --i) {
            len += this.strings[i].length();
        }
        return len;
    }

    @Override
    public char charAt(int index) {
        if (this.strings == null) {
            return '\u0000';
        }
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = this.strings[i].length();
            if (index < l) {
                return this.strings[i].charAt(index);
            }
            index -= l;
        }
        return '\u0000';
    }

    @Override
    public void setCharAt(int index, char c) throws IllegalArgumentException {
        if (this.strings == null) {
            throw new IllegalArgumentException("String is empty");
        }
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = this.strings[i].length();
            if (index < l) {
                this.strings[i].setCharAt(index, c);
                return;
            }
            index -= l;
        }
        throw new IllegalArgumentException("String is smaller than the given index");
    }

    @Override
    public UnprotectedStringBuffer append(char c) {
        if (this.strings == null) {
            this.strings = new UnprotectedString[8];
            this.strings[0] = new UnprotectedString(64);
            this.strings[0].append(c);
            this.lastUsed = 0;
            return this;
        }
        if (this.strings[this.lastUsed].canAppendWithoutEnlarging() > 0) {
            this.strings[this.lastUsed].append(c);
            return this;
        }
        if (this.lastUsed < this.strings.length - 1) {
            this.strings[++this.lastUsed] = new UnprotectedString(64);
            this.strings[this.lastUsed].append(c);
            return this;
        }
        UnprotectedString[] a = new UnprotectedString[this.lastUsed + 1 + 8];
        System.arraycopy(this.strings, 0, a, 0, this.lastUsed + 1);
        a[++this.lastUsed] = new UnprotectedString(64);
        a[this.lastUsed].append(c);
        this.strings = a;
        return this;
    }

    @Override
    public UnprotectedStringBuffer append(char[] chars, int offset, int len) {
        if (this.strings == null) {
            this.strings = new UnprotectedString[8];
            this.strings[0] = new UnprotectedString(len > 50 ? len + 64 : 64);
            this.strings[0].append(chars, offset, len);
            this.lastUsed = 0;
            return this;
        }
        int l = this.strings[this.lastUsed].canAppendWithoutEnlarging();
        if (l > 0) {
            if (l > len) {
                l = len;
            }
            this.strings[this.lastUsed].append(chars, offset, l);
            if ((len -= l) == 0) {
                return this;
            }
            offset += l;
        }
        if (this.lastUsed < this.strings.length - 1) {
            this.strings[++this.lastUsed] = new UnprotectedString(len > 50 ? len + 64 : 64);
            this.strings[this.lastUsed].append(chars, offset, len);
            return this;
        }
        UnprotectedString[] a = new UnprotectedString[this.lastUsed + 1 + 8];
        System.arraycopy(this.strings, 0, a, 0, this.lastUsed + 1);
        a[++this.lastUsed] = new UnprotectedString(len > 50 ? len + 64 : 64);
        a[this.lastUsed].append(chars, offset, len);
        this.strings = a;
        return this;
    }

    @Override
    public UnprotectedStringBuffer append(CharSequence s) {
        if (s instanceof UnprotectedStringBuffer) {
            UnprotectedStringBuffer us = (UnprotectedStringBuffer)s;
            if (us.strings == null) {
                return this;
            }
            if (this.strings == null) {
                this.strings = new UnprotectedString[us.strings.length];
                System.arraycopy(us.strings, 0, this.strings, 0, this.strings.length);
                this.lastUsed = us.lastUsed;
                return this;
            }
            int i = 0;
            while (this.lastUsed < this.strings.length - 1 && i <= us.lastUsed) {
                this.strings[++this.lastUsed] = us.strings[i++];
            }
            if (i > us.lastUsed) {
                return this;
            }
            UnprotectedString[] a = new UnprotectedString[this.strings.length + (us.lastUsed - i + 1) + 8];
            System.arraycopy(this.strings, 0, a, 0, this.strings.length);
            System.arraycopy(us.strings, i, a, this.strings.length, us.lastUsed - i + 1);
            this.lastUsed = this.strings.length + (us.lastUsed - i + 1) - 1;
            this.strings = a;
            return this;
        }
        if (s instanceof UnprotectedString) {
            UnprotectedString us = (UnprotectedString)s;
            if (this.strings == null) {
                this.strings = new UnprotectedString[8];
                this.strings[0] = us;
                this.lastUsed = 0;
                return this;
            }
            if (this.lastUsed < this.strings.length - 1) {
                this.strings[++this.lastUsed] = us;
                return this;
            }
            UnprotectedString[] a = new UnprotectedString[this.strings.length + 8];
            System.arraycopy(this.strings, 0, a, 0, this.strings.length);
            a[this.strings.length] = us;
            ++this.lastUsed;
            this.strings = a;
            return this;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.append(s.charAt(i));
        }
        return this;
    }

    public UnprotectedStringBuffer addFirst(CharSequence s) {
        return this.addFirst(new UnprotectedString(s));
    }

    public UnprotectedStringBuffer addFirst(UnprotectedString s) {
        if (this.strings == null) {
            this.strings = new UnprotectedString[]{s};
            this.lastUsed = 0;
            return this;
        }
        if (this.lastUsed < this.strings.length - 1) {
            System.arraycopy(this.strings, 0, this.strings, 1, this.lastUsed + 1);
            this.strings[0] = s;
            ++this.lastUsed;
            return this;
        }
        UnprotectedString[] ns = new UnprotectedString[this.lastUsed + 8];
        System.arraycopy(this.strings, 0, ns, 1, this.lastUsed + 1);
        ns[0] = s;
        this.strings = ns;
        ++this.lastUsed;
        return this;
    }

    public UnprotectedStringBuffer addFirst(char c) {
        return this.addFirst(new UnprotectedString(c));
    }

    @Override
    public int indexOf(char c, int start) {
        if (this.strings == null) {
            return -1;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = this.strings[i].length();
            if (pos + l <= start) {
                pos += l;
                continue;
            }
            int j = pos < start ? this.strings[i].indexOf(c, start - pos) : this.strings[i].indexOf(c);
            if (j >= 0) {
                return j + pos;
            }
            pos += l;
        }
        return -1;
    }

    @Override
    public int indexOf(CharSequence s, int start) {
        int sl = s.length();
        if (sl == 0) {
            return -1;
        }
        if (this.strings == null) {
            return -1;
        }
        char first = s.charAt(0);
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            int j;
            int l = this.strings[i].length();
            if (pos + l <= start) {
                pos += l;
                continue;
            }
            int n = j = pos < start ? start - pos : 0;
            while (j < l) {
                if (this.strings[i].charAt(j) == first) {
                    int k;
                    int jj = j;
                    int ii = i;
                    int ll = l;
                    for (k = 1; k < sl; ++k) {
                        if (++jj == ll) {
                            if (++ii == this.lastUsed + 1) {
                                return -1;
                            }
                            jj = 0;
                            ll = this.strings[ii].length();
                        }
                        if (this.strings[ii].charAt(jj) != s.charAt(k)) break;
                    }
                    if (k == sl) {
                        return pos + j;
                    }
                }
                ++j;
            }
            pos += l;
        }
        return -1;
    }

    @Override
    public StringBuilder subSequence(int start, int end) {
        StringBuilder s = new StringBuilder();
        if (this.strings == null) {
            return s;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = this.strings[i].length();
            if (start < pos + l) {
                int j = end - pos;
                if (j > l) {
                    j = l;
                }
                s.append(this.strings[i].subSequence(start - pos, j));
                start = pos + j;
                if (start >= end) break;
            }
            pos += l;
        }
        return s;
    }

    @Override
    public UnprotectedStringBuffer substring(int start) {
        if (this.strings == null) {
            return this;
        }
        int pos = 0;
        LinkedList<UnprotectedString> list = new LinkedList<UnprotectedString>();
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = this.strings[i].length();
            if (start < pos + l) {
                list.add(this.strings[i].substring(start - pos, l));
                start = pos + l;
            }
            pos += l;
        }
        return new UnprotectedStringBuffer(list);
    }

    @Override
    public UnprotectedStringBuffer substring(int start, int end) {
        if (this.strings == null) {
            return this;
        }
        int pos = 0;
        LinkedList<UnprotectedString> list = new LinkedList<UnprotectedString>();
        for (int i = 0; i <= this.lastUsed; ++i) {
            int l = this.strings[i].length();
            if (start < pos + l) {
                int j = end - pos;
                if (j > l) {
                    j = l;
                }
                list.add(this.strings[i].substring(start - pos, j));
                start = pos + j;
                if (start >= end) break;
            }
            pos += l;
        }
        return new UnprotectedStringBuffer(list);
    }

    @Override
    public int fill(char[] chars, int start) {
        if (this.strings == null) {
            return 0;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            pos += this.strings[i].fill(chars, start + pos);
        }
        return pos;
    }

    @Override
    public int fillUsAsciiBytes(byte[] bytes, int start) {
        if (this.strings == null) {
            return 0;
        }
        int pos = 0;
        for (int i = 0; i <= this.lastUsed; ++i) {
            pos += this.strings[i].fillUsAsciiBytes(bytes, start + pos);
        }
        return pos;
    }

    @Override
    public UnprotectedStringBuffer trimBeginning() {
        if (this.strings != null) {
            this.strings[0].trimBeginning();
        }
        return this;
    }

    @Override
    public UnprotectedStringBuffer trimEnd() {
        if (this.strings != null) {
            this.strings[this.lastUsed].trimEnd();
        }
        return this;
    }

    @Override
    public UnprotectedStringBuffer removeStartChars(int nb) {
        while (this.strings != null) {
            int l = this.strings[0].length();
            if (nb < l) {
                this.strings[0].removeStartChars(nb);
                return this;
            }
            if (this.lastUsed == 0) {
                this.strings = null;
                return this;
            }
            System.arraycopy(this.strings, 1, this.strings, 0, this.lastUsed - 1);
            this.strings[this.lastUsed] = null;
            --this.lastUsed;
            nb -= l;
        }
        return this;
    }

    @Override
    public UnprotectedStringBuffer removeEndChars(int nb) {
        while (this.strings != null) {
            int l = this.strings[this.lastUsed].length();
            if (nb < l) {
                this.strings[this.lastUsed].removeEndChars(nb);
                return this;
            }
            if (this.lastUsed == 0) {
                this.strings = null;
                return this;
            }
            this.strings[this.lastUsed] = null;
            --this.lastUsed;
            nb -= l;
        }
        return this;
    }

    public LinkedList<UnprotectedStringBuffer> split(char sep) {
        LinkedList<UnprotectedStringBuffer> list = new LinkedList<UnprotectedStringBuffer>();
        if (this.strings == null) {
            return list;
        }
        UnprotectedStringBuffer current = new UnprotectedStringBuffer();
        block0: for (int index = 0; index <= this.lastUsed; ++index) {
            int i;
            int pos = 0;
            do {
                if ((i = this.strings[index].indexOf(sep, pos)) < 0) {
                    current.append(this.strings[index].substring(pos, this.strings[index].length()));
                    continue block0;
                }
                if (current.length() == 0) {
                    list.add(new UnprotectedStringBuffer(this.strings[index].substring(pos, i)));
                    continue;
                }
                current.append(this.strings[index].substring(pos, i));
                list.add(current);
                current = new UnprotectedStringBuffer();
            } while ((pos = i + 1) < this.strings[index].length());
        }
        if (current.length() > 0) {
            list.add(current);
        }
        return list;
    }

    private UnprotectedStringBuffer subBuffer(int startBuffer, int startBufferIndex, int endBuffer, int endBufferIndex) {
        UnprotectedStringBuffer result = new UnprotectedStringBuffer();
        result.strings = new UnprotectedString[endBuffer - startBuffer + 1];
        result.lastUsed = result.strings.length - 1;
        for (int buffer = startBuffer; buffer <= endBuffer; ++buffer) {
            int start = buffer == startBuffer ? startBufferIndex : 0;
            int end = buffer == endBuffer ? endBufferIndex : this.strings[buffer].length();
            result.strings[buffer - startBuffer] = this.strings[buffer].substring(start, end);
        }
        return result;
    }

    private void replace(int startBuffer, int startBufferIndex, int endBuffer, int endBufferIndex, UnprotectedStringBuffer replace) {
        int i;
        ArrayList<UnprotectedString> list = new ArrayList<UnprotectedString>(startBuffer + 1 + replace.lastUsed + 1 + this.lastUsed - endBuffer + 1);
        for (i = 0; i < startBuffer; ++i) {
            list.add(this.strings[i]);
        }
        if (startBufferIndex > 0) {
            list.add(this.strings[startBuffer].substring(0, startBufferIndex));
        }
        if (replace.strings != null) {
            for (i = 0; i <= replace.lastUsed; ++i) {
                list.add(replace.strings[i]);
            }
        }
        if (endBufferIndex < this.strings[endBuffer].length() - 1) {
            list.add(this.strings[endBuffer].substring(endBufferIndex + 1));
        }
        for (i = endBuffer + 1; i <= this.lastUsed; ++i) {
            list.add(this.strings[i]);
        }
        this.strings = list.toArray(new UnprotectedString[list.size()]);
        this.lastUsed = this.strings.length - 1;
    }

    public UnprotectedStringBuffer replace(CharSequence search, UnprotectedString replace) {
        int pos = 0;
        while ((pos = this.indexOf(search, pos)) >= 0) {
            this.replace(pos, pos + search.length() - 1, replace);
            pos += replace.length();
        }
        return this;
    }

    public UnprotectedStringBuffer replace(CharSequence search, CharSequence replace) {
        return this.replace(search, new UnprotectedString(replace));
    }

    @Override
    public UnprotectedStringBuffer replace(char oldChar, char newChar) {
        if (this.strings != null) {
            for (int i = 0; i <= this.lastUsed; ++i) {
                this.strings[i].replace(oldChar, newChar);
            }
        }
        return this;
    }

    public UnprotectedStringBuffer replace(char oldChar, CharSequence replaceValue) {
        return this.replace(oldChar, new UnprotectedString(replaceValue));
    }

    public UnprotectedStringBuffer replace(char oldChar, UnprotectedString replaceValue) {
        if (replaceValue.length() == 1) {
            return this.replace(oldChar, replaceValue.charAt(0));
        }
        if (this.strings == null) {
            return this;
        }
        int pos = 0;
        while ((pos = this.indexOf(oldChar, pos)) >= 0) {
            this.replace(pos, pos, replaceValue);
            pos += replaceValue.length();
        }
        return this;
    }

    public void replace(int start, int end, char c) {
        this.replace(start, end, new char[]{c});
    }

    public void replace(int start, int end, char[] chars) {
        this.replace(start, end, new UnprotectedString(chars));
    }

    public void replace(int start, int end, UnprotectedString s) {
        int firstBufferLen;
        if (this.strings == null) {
            return;
        }
        if (end < start) {
            return;
        }
        int firstBufferIndex = 0;
        int firstBufferPos = 0;
        while (start >= firstBufferPos + (firstBufferLen = this.strings[firstBufferIndex].length())) {
            firstBufferPos += firstBufferLen;
            if (++firstBufferIndex <= this.lastUsed) continue;
            return;
        }
        int lastBufferIndex = firstBufferIndex;
        int lastBufferPos = firstBufferPos;
        int lastBufferLen = firstBufferLen;
        while (end >= lastBufferPos + lastBufferLen) {
            if (++lastBufferIndex > this.lastUsed) {
                --lastBufferIndex;
                end = lastBufferPos + lastBufferLen - 1;
                break;
            }
            lastBufferPos += lastBufferLen;
            lastBufferLen = this.strings[lastBufferIndex].length();
        }
        this.replaceStrings(firstBufferIndex, lastBufferIndex, start == firstBufferPos ? null : this.strings[firstBufferIndex].substring(0, start - firstBufferPos), end == lastBufferPos + lastBufferLen - 1 ? null : this.strings[lastBufferIndex].substring(end - lastBufferPos + 1), 1, s);
    }

    public UnprotectedStringBuffer replace(int start, int end, UnprotectedStringBuffer s) {
        int firstBufferLen;
        if (this.strings == null) {
            return this;
        }
        if (end < start) {
            return this;
        }
        int firstBufferIndex = 0;
        int firstBufferPos = 0;
        while (start >= firstBufferPos + (firstBufferLen = this.strings[firstBufferIndex].length())) {
            firstBufferPos += firstBufferLen;
            if (++firstBufferIndex <= this.lastUsed) continue;
            return this;
        }
        int lastBufferIndex = firstBufferIndex;
        int lastBufferPos = firstBufferPos;
        int lastBufferLen = firstBufferLen;
        while (end >= lastBufferPos + lastBufferLen) {
            if (++lastBufferIndex > this.lastUsed) {
                --lastBufferIndex;
                end = lastBufferPos + lastBufferLen - 1;
                break;
            }
            lastBufferPos += lastBufferLen;
            lastBufferLen = this.strings[lastBufferIndex].length();
        }
        this.replaceStrings(firstBufferIndex, lastBufferIndex, start == firstBufferPos ? null : this.strings[firstBufferIndex].substring(0, start - firstBufferPos), end == lastBufferPos + lastBufferLen - 1 ? null : this.strings[lastBufferIndex].substring(end - lastBufferPos + 1), s.strings == null ? 0 : s.lastUsed + 1, s.strings);
        return this;
    }

    private void replaceStrings(int startIndex, int endIndex, UnprotectedString first, UnprotectedString last, int nbMiddle, UnprotectedString ... middle) {
        int nb = startIndex + (this.lastUsed - endIndex) + (first != null ? 1 : 0) + (last != null ? 1 : 0) + nbMiddle;
        if (nb <= this.strings.length) {
            int i;
            int pos;
            if (endIndex < this.lastUsed) {
                System.arraycopy(this.strings, endIndex + 1, this.strings, nb - (this.lastUsed - endIndex), this.lastUsed - endIndex);
                pos = nb - (this.lastUsed - endIndex) - 1;
            } else {
                pos = nb - 1;
            }
            if (last != null) {
                this.strings[pos--] = last;
            }
            for (i = nbMiddle - 1; i >= 0; --i) {
                this.strings[pos--] = middle[i];
            }
            if (first != null) {
                this.strings[pos] = first;
            }
            for (i = nb; i <= this.lastUsed; ++i) {
                this.strings[i] = null;
            }
            this.lastUsed = nb - 1;
            return;
        }
        UnprotectedString[] list = new UnprotectedString[nb + 3];
        int pos = 0;
        if (startIndex > 0) {
            System.arraycopy(this.strings, 0, list, 0, startIndex);
            pos = startIndex;
        }
        if (first != null) {
            list[pos++] = first;
        }
        for (int i = 0; i < nbMiddle; ++i) {
            list[pos++] = middle[i];
        }
        if (last != null) {
            list[pos++] = last;
        }
        if (endIndex < this.lastUsed) {
            System.arraycopy(this.strings, endIndex + 1, list, pos, this.lastUsed - endIndex);
        }
        this.strings = list;
        this.lastUsed = nb - 1;
    }

    public void searchAndReplace(CharSequence start, CharSequence end, Provider.FromValue<UnprotectedStringBuffer, UnprotectedStringBuffer> valueProvider) {
        if (this.strings == null) {
            return;
        }
        int buffer = 0;
        int bufferIndex = 0;
        int startIndex = 0;
        char startChar = start.charAt(0);
        int startOfStartBuffer = 0;
        int startOfStartBufferIndex = 0;
        block0: while (buffer <= this.lastUsed) {
            if (bufferIndex >= this.strings[buffer].length()) {
                ++buffer;
                bufferIndex = 0;
                continue;
            }
            char c = this.strings[buffer].charAt(bufferIndex);
            if (c != startChar) {
                if (startIndex > 0) {
                    startIndex = 0;
                    startChar = start.charAt(0);
                }
                ++bufferIndex;
                continue;
            }
            if (startIndex == 0) {
                startOfStartBuffer = buffer;
                startOfStartBufferIndex = bufferIndex;
            }
            if (startIndex == start.length() - 1) {
                startIndex = 0;
                startChar = start.charAt(0);
                int endIndex = 0;
                char endChar = end.charAt(0);
                int endOfStartBuffer = buffer;
                int endOfStartBufferIndex = bufferIndex++;
                while (buffer <= this.lastUsed) {
                    if (bufferIndex >= this.strings[buffer].length()) {
                        ++buffer;
                        bufferIndex = 0;
                        continue;
                    }
                    c = this.strings[buffer].charAt(bufferIndex);
                    if (c != endChar) {
                        if (endIndex > 0) {
                            endIndex = 0;
                            endChar = end.charAt(0);
                        }
                        ++bufferIndex;
                        continue;
                    }
                    if (endIndex == end.length() - 1) {
                        int i;
                        if (++endOfStartBufferIndex == this.strings[endOfStartBuffer].length()) {
                            ++endOfStartBuffer;
                            endOfStartBufferIndex = 0;
                        }
                        int b = buffer;
                        for (i = bufferIndex - end.length() + 1; i < 0; i += this.strings[--b].length()) {
                        }
                        UnprotectedStringBuffer variable = this.subBuffer(endOfStartBuffer, endOfStartBufferIndex, b, i);
                        UnprotectedStringBuffer value = valueProvider.provide(variable);
                        this.replace(startOfStartBuffer, startOfStartBufferIndex, buffer, bufferIndex, value);
                        ++bufferIndex;
                        bufferIndex -= start.length() + end.length() + variable.length();
                        bufferIndex += value.length();
                        while (bufferIndex < 0) {
                            bufferIndex += this.strings[--buffer].length();
                        }
                        while (buffer <= this.lastUsed && bufferIndex >= this.strings[buffer].length()) {
                            bufferIndex -= this.strings[buffer].length();
                            ++buffer;
                        }
                        continue block0;
                    }
                    endChar = end.charAt(++endIndex);
                }
                continue;
            }
            startChar = start.charAt(++startIndex);
            ++bufferIndex;
        }
    }

    @Override
    public UnprotectedStringBuffer toLowerCase() {
        if (this.strings != null) {
            for (int i = 0; i <= this.lastUsed; ++i) {
                this.strings[i].toLowerCase();
            }
        }
        return this;
    }

    @Override
    public UnprotectedStringBuffer toUpperCase() {
        if (this.strings != null) {
            for (int i = 0; i <= this.lastUsed; ++i) {
                this.strings[i].toUpperCase();
            }
        }
        return this;
    }

    @Override
    public boolean startsWith(CharSequence start) {
        if (this.strings == null) {
            return start.length() == 0;
        }
        int l = start.length();
        int stringIndex = 0;
        int stringPos = 0;
        int stringLen = this.strings[0].length();
        for (int i = 0; i < l; ++i) {
            if (this.strings[stringIndex].charAt(stringPos) != start.charAt(i)) {
                return false;
            }
            if (i == l - 1) {
                return true;
            }
            if (++stringPos != stringLen) continue;
            if (++stringIndex > this.lastUsed) {
                return false;
            }
            stringPos = 0;
            stringLen = this.strings[stringIndex].length();
        }
        return true;
    }

    @Override
    public boolean endsWith(CharSequence end) {
        if (this.strings == null) {
            return end.length() == 0;
        }
        int stringIndex = this.lastUsed;
        int stringPos = this.strings[stringIndex].length() - 1;
        for (int i = end.length() - 1; i >= 0; --i) {
            if (this.strings[stringIndex].charAt(stringPos) != end.charAt(i)) {
                return false;
            }
            if (i == 0) {
                return true;
            }
            if (--stringPos >= 0) continue;
            if (--stringIndex < 0) {
                return false;
            }
            stringPos = this.strings[stringIndex].length() - 1;
        }
        return true;
    }

    @Override
    public String toString() {
        if (this.strings == null) {
            return "";
        }
        if (this.lastUsed == 0) {
            return this.strings[0].toString();
        }
        char[] chars = new char[this.length()];
        this.fill(chars, 0);
        return new String(chars);
    }

    @Override
    public char[][] asCharacters() {
        if (this.strings == null) {
            return new char[0][];
        }
        char[][] chars = new char[this.lastUsed + 1][];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = new char[this.strings[i].length()];
            this.strings[i].fill(chars[i]);
        }
        return chars;
    }

    @Override
    public CharBuffer[] asCharBuffers() {
        if (this.strings == null) {
            return new CharBuffer[0];
        }
        CharBuffer[] chars = new CharBuffer[this.lastUsed + 1];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = this.strings[i].asCharBuffer();
        }
        return chars;
    }

    public ICharacterStream.Readable.Buffered asCharacterStream() {
        return new CS();
    }

    public ICharacterStream.Writable.Buffered asWritableCharacterStream() {
        return new WCS();
    }

    public SynchronizationPoint<IOException> encode(Charset charset, IO.Writable output, byte priority) {
        if (this.strings == null) {
            return new SynchronizationPoint<boolean>(true);
        }
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        CharsetEncoder encoder = charset.newEncoder();
        this.encode(0, encoder, output, priority, null, result);
        return result;
    }

    private void encode(int index, CharsetEncoder encoder, IO.Writable output, byte priority, ISynchronizationPoint<IOException> prevWrite, SynchronizationPoint<IOException> result) {
        new Task.Cpu.FromRunnable("Encode string into bytes", priority, () -> {
            try {
                ByteBuffer bytes = encoder.encode(this.strings[index].asCharBuffer());
                if (prevWrite == null || prevWrite.isUnblocked()) {
                    if (prevWrite != null && prevWrite.hasError()) {
                        result.error((IOException)prevWrite.getError());
                        return;
                    }
                    AsyncWork<Integer, IOException> write = output.writeAsync(bytes);
                    if (index == this.lastUsed) {
                        write.listenInline(result);
                        return;
                    }
                    this.encode(index + 1, encoder, output, priority, write, result);
                    return;
                }
                prevWrite.listenInline(() -> {
                    AsyncWork<Integer, IOException> write = output.writeAsync(bytes);
                    if (index == this.lastUsed) {
                        write.listenInline(result);
                        return;
                    }
                    this.encode(index + 1, encoder, output, priority, write, result);
                }, result);
            }
            catch (IOException e) {
                result.error(e);
            }
        }).start();
    }

    protected class WCS
    extends ConcurrentCloseable
    implements ICharacterStream.Writable.Buffered {
        private byte priority = (byte)4;

        protected WCS() {
        }

        @Override
        public void writeSync(char[] c, int offset, int length) {
            UnprotectedStringBuffer.this.append(c, offset, length);
        }

        @Override
        public void writeSync(char c) throws IOException {
            UnprotectedStringBuffer.this.append(c);
        }

        @Override
        public ISynchronizationPoint<IOException> writeAsync(final char[] c, final int offset, final int length) {
            return new Task.Cpu<Void, IOException>("UnprotectedStringBuffer.writeAsync", this.priority){

                @Override
                public Void run() throws IOException, CancelException {
                    UnprotectedStringBuffer.this.append(c, offset, length);
                    return null;
                }
            }.start().getOutput();
        }

        @Override
        public ISynchronizationPoint<IOException> writeAsync(char c) {
            UnprotectedStringBuffer.this.append(c);
            return new SynchronizationPoint<boolean>(true);
        }

        @Override
        public ISynchronizationPoint<IOException> flush() {
            return new SynchronizationPoint<boolean>(true);
        }

        @Override
        public byte getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(byte priority) {
            this.priority = priority;
        }

        @Override
        protected ISynchronizationPoint<?> closeUnderlyingResources() {
            return null;
        }

        @Override
        protected void closeResources(SynchronizationPoint<Exception> ondone) {
            ondone.unblock();
        }

        @Override
        public String getDescription() {
            return "UnprotectedStringBuffer";
        }

        @Override
        public Charset getEncoding() {
            return StandardCharsets.UTF_16;
        }
    }

    protected class CS
    extends ConcurrentCloseable
    implements ICharacterStream.Readable.Buffered {
        private int buffer = 0;
        private int bufferIndex = 0;
        private byte priority = (byte)4;

        protected CS() {
        }

        @Override
        protected ISynchronizationPoint<?> closeUnderlyingResources() {
            return null;
        }

        @Override
        protected void closeResources(SynchronizationPoint<Exception> ondone) {
            ondone.unblock();
        }

        @Override
        public String getDescription() {
            return "UnprotectedStringBuffer";
        }

        @Override
        public Charset getEncoding() {
            return StandardCharsets.UTF_16;
        }

        @Override
        public char read() throws EOFException {
            if (UnprotectedStringBuffer.this.strings == null) {
                throw new EOFException();
            }
            while (this.buffer <= UnprotectedStringBuffer.this.lastUsed && this.bufferIndex == UnprotectedStringBuffer.this.strings[this.buffer].length()) {
                ++this.buffer;
                this.bufferIndex = 0;
            }
            if (this.buffer > UnprotectedStringBuffer.this.lastUsed) {
                throw new EOFException();
            }
            return UnprotectedStringBuffer.this.strings[this.buffer].charAt(this.bufferIndex++);
        }

        @Override
        public int readSync(char[] buf, int offset, int length) {
            if (UnprotectedStringBuffer.this.strings == null) {
                return -1;
            }
            int done = 0;
            while (true) {
                if (this.buffer <= UnprotectedStringBuffer.this.lastUsed && this.bufferIndex == UnprotectedStringBuffer.this.strings[this.buffer].length()) {
                    ++this.buffer;
                    this.bufferIndex = 0;
                    continue;
                }
                if (this.buffer > UnprotectedStringBuffer.this.lastUsed) {
                    return done > 0 ? done : -1;
                }
                int len = UnprotectedStringBuffer.this.strings[this.buffer].length() - this.bufferIndex;
                if (len > length) {
                    len = length;
                }
                System.arraycopy(UnprotectedStringBuffer.this.strings[this.buffer].charArray(), UnprotectedStringBuffer.this.strings[this.buffer].charArrayStart() + this.bufferIndex, buf, offset, len);
                this.bufferIndex += len;
                offset += len;
                done += len;
                if ((length -= len) == 0) break;
            }
            return done;
        }

        @Override
        public int readAsync() {
            if (UnprotectedStringBuffer.this.strings == null) {
                return -1;
            }
            while (this.buffer <= UnprotectedStringBuffer.this.lastUsed && this.bufferIndex == UnprotectedStringBuffer.this.strings[this.buffer].length()) {
                ++this.buffer;
                this.bufferIndex = 0;
            }
            if (this.buffer > UnprotectedStringBuffer.this.lastUsed) {
                return -1;
            }
            return UnprotectedStringBuffer.this.strings[this.buffer].charAt(this.bufferIndex++);
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(final char[] buf, final int offset, final int length) {
            return new Task.Cpu<Integer, IOException>("UnprotectedStringBuffer.readAsync", this.priority){

                @Override
                public Integer run() {
                    return CS.this.readSync(buf, offset, length);
                }
            }.start().getOutput();
        }

        @Override
        public AsyncWork<UnprotectedString, IOException> readNextBufferAsync() {
            if (UnprotectedStringBuffer.this.strings == null) {
                return new AsyncWork<Object, Object>(null, null);
            }
            while (this.buffer <= UnprotectedStringBuffer.this.lastUsed && this.bufferIndex == UnprotectedStringBuffer.this.strings[this.buffer].length()) {
                ++this.buffer;
                this.bufferIndex = 0;
            }
            if (this.buffer > UnprotectedStringBuffer.this.lastUsed) {
                return new AsyncWork<Object, Object>(null, null);
            }
            UnprotectedString str = UnprotectedStringBuffer.this.strings[this.buffer].substring(this.bufferIndex);
            ++this.buffer;
            this.bufferIndex = 0;
            return new AsyncWork<UnprotectedString, Object>(str, null);
        }

        @Override
        public byte getPriority() {
            return this.priority;
        }

        @Override
        public void setPriority(byte priority) {
            this.priority = priority;
        }

        @Override
        public void back(char c) {
            if (UnprotectedStringBuffer.this.strings == null) {
                UnprotectedStringBuffer.this.append(c);
                this.buffer = 0;
                this.bufferIndex = 0;
                return;
            }
            while (this.bufferIndex == 0 && this.buffer > 0) {
                --this.buffer;
                this.bufferIndex = UnprotectedStringBuffer.this.strings[this.buffer].length();
            }
            if (this.bufferIndex == 0 && this.buffer == 0) {
                UnprotectedStringBuffer.this.addFirst(c);
                return;
            }
            UnprotectedStringBuffer.this.strings[this.buffer].setCharAt(--this.bufferIndex, c);
        }

        @Override
        public boolean endReached() {
            return UnprotectedStringBuffer.this.strings == null || this.buffer > UnprotectedStringBuffer.this.lastUsed;
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return new SynchronizationPoint<boolean>(true);
        }
    }
}

