/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.nio.charset.StandardCharsets;
import net.lecousin.framework.io.encoding.IBytesEncoding;
import net.lecousin.framework.io.util.DataUtil;

public interface StringEncoding<T> {
    public String encode(T var1);

    public T decode(String var1);

    public static class EncodedLong
    implements StringEncoding<Long> {
        protected IBytesEncoding encoder;

        public EncodedLong(IBytesEncoding encoder) {
            this.encoder = encoder;
        }

        @Override
        public String encode(Long value) {
            return new String(this.encoder.encode(DataUtil.getBytesLittleEndian(value)), StandardCharsets.ISO_8859_1);
        }

        @Override
        public Long decode(String string) {
            return DataUtil.readLongLittleEndian(this.encoder.decode(string.getBytes(StandardCharsets.ISO_8859_1)), 0);
        }
    }

    public static class SimpleLong
    implements StringEncoding<Long> {
        @Override
        public String encode(Long value) {
            return value.toString();
        }

        @Override
        public Long decode(String string) {
            return Long.valueOf(string);
        }
    }

    public static class SimpleInteger
    implements StringEncoding<Integer> {
        @Override
        public String encode(Integer value) {
            return value.toString();
        }

        @Override
        public Integer decode(String string) {
            return Integer.valueOf(string);
        }
    }
}

