/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.List;

public interface IString
extends CharSequence {
    public void setCharAt(int var1, char var2) throws IllegalArgumentException;

    public IString append(char var1);

    public IString append(char[] var1, int var2, int var3);

    default public IString append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public IString append(CharSequence var1);

    public int indexOf(char var1, int var2);

    public int indexOf(CharSequence var1, int var2);

    default public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    default public int indexOf(CharSequence s) {
        return this.indexOf(s, 0);
    }

    public IString substring(int var1);

    public IString substring(int var1, int var2);

    public int fill(char[] var1, int var2);

    default public int fill(char[] chars) {
        return this.fill(chars, 0);
    }

    public int fillUsAsciiBytes(byte[] var1, int var2);

    default public int fillUsAsciiBytes(byte[] bytes) {
        return this.fillUsAsciiBytes(bytes, 0);
    }

    default public byte[] toUsAsciiBytes() {
        byte[] bytes = new byte[this.length()];
        this.fillUsAsciiBytes(bytes, 0);
        return bytes;
    }

    public IString trimBeginning();

    public IString trimEnd();

    default public IString trim() {
        this.trimBeginning();
        this.trimEnd();
        return this;
    }

    public IString replace(char var1, char var2);

    public IString removeEndChars(int var1);

    public IString removeStartChars(int var1);

    public IString toLowerCase();

    public IString toUpperCase();

    public List<? extends IString> split(char var1);

    default public boolean equals(CharSequence s) {
        int l = this.length();
        if (s.length() != l) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (s.charAt(i) == this.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence var1);

    public boolean endsWith(CharSequence var1);

    default public boolean isStartOf(CharSequence s) {
        int l = this.length();
        if (l > s.length()) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    default public String asString() {
        char[] chars = new char[this.length()];
        this.fill(chars);
        return new String(chars);
    }

    default public char[][] asCharacters() {
        char[] chars = new char[this.length()];
        this.fill(chars);
        return new char[][]{chars};
    }

    public CharBuffer[] asCharBuffers();

    default public ByteBuffer encode(Charset cs) {
        CharBuffer[] cbs = this.asCharBuffers();
        int len = this.length();
        CharsetEncoder ce = cs.newEncoder();
        int en = (int)((float)len * ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        if (len == 0) {
            return ByteBuffer.wrap(ba);
        }
        ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        ByteBuffer bb = ByteBuffer.wrap(ba);
        try {
            CoderResult cr = null;
            for (int i = 0; i < cbs.length; ++i) {
                cr = ce.encode(cbs[i], bb, i == cbs.length - 1);
            }
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        bb.flip();
        return bb;
    }
}

