/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.util.Random;
import net.lecousin.framework.math.FragmentedRangeLong;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.IDManager;
import net.lecousin.framework.util.StringEncoding;

public class IDManagerRandomLong
implements IDManager {
    private StringEncoding<Long> encoder;
    private Random rand;
    private FragmentedRangeLong free = new FragmentedRangeLong(new RangeLong(1L, Long.MAX_VALUE));

    public IDManagerRandomLong(StringEncoding<Long> encoder) {
        this.encoder = encoder;
        this.rand = new Random();
    }

    public IDManagerRandomLong() {
        this(new StringEncoding.SimpleLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String allocate() {
        long id;
        long n = this.rand.nextLong();
        FragmentedRangeLong fragmentedRangeLong = this.free;
        synchronized (fragmentedRangeLong) {
            long max = this.free.getTotalSize();
            if ((n %= max) < 0L) {
                n = -n;
            }
            id = this.free.removeValueAt(n);
        }
        return this.encoder.encode(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(String id) {
        long l = this.encoder.decode(id);
        FragmentedRangeLong fragmentedRangeLong = this.free;
        synchronized (fragmentedRangeLong) {
            this.free.addValue(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void used(String id) {
        long l = this.encoder.decode(id);
        FragmentedRangeLong fragmentedRangeLong = this.free;
        synchronized (fragmentedRangeLong) {
            this.free.removeValue(l);
        }
    }
}

