/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import net.lecousin.framework.math.FragmentedRangeLong;
import net.lecousin.framework.math.RangeLong;
import net.lecousin.framework.util.IDManager;
import net.lecousin.framework.util.StringEncoding;

public class IDManagerLong
implements IDManager {
    private StringEncoding<Long> encoder;
    private FragmentedRangeLong free = new FragmentedRangeLong(new RangeLong(1L, Long.MAX_VALUE));

    public IDManagerLong(StringEncoding<Long> encoder) {
        this.encoder = encoder;
    }

    public IDManagerLong() {
        this(new StringEncoding.SimpleLong());
    }

    @Override
    public String allocate() {
        Long id = this.free.removeFirstValue();
        return this.encoder.encode(id);
    }

    @Override
    public void free(String id) {
        long l = this.encoder.decode(id);
        this.free.addValue(l);
    }

    @Override
    public void used(String id) {
        long l = this.encoder.decode(id);
        this.free.removeValue(l);
    }
}

