/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.tasks.drives.DirectoryReader;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.util.FileInfo;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.util.Triple;

public abstract class DirectoryWalker<T> {
    private File root;
    private T rootObject;
    private DirectoryReader.Request request;
    private TaskManager taskManager;

    public DirectoryWalker(File root, T rootObject, DirectoryReader.Request request) {
        this.root = root;
        this.rootObject = rootObject;
        this.request = request;
        this.taskManager = Threading.getDrivesTaskManager().getTaskManager(root);
    }

    public ISynchronizationPoint<IOException> start(byte priority, WorkProgress progress, long work) {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        jp.addToJoin(1);
        this.processDirectory("", this.root, this.rootObject, jp, priority, progress, work);
        jp.start();
        return jp;
    }

    protected void accessDenied(File dir, String path) {
    }

    protected abstract T directoryFound(T var1, FileInfo var2, String var3);

    protected abstract void fileFound(T var1, FileInfo var2, String var3);

    private void processDirectory(final String path, final File dir, final T object, final JoinPoint<IOException> jp, final byte priority, final WorkProgress prog, final long work) {
        final DirectoryReader reader = new DirectoryReader(this.taskManager, dir, priority, this.request){

            @Override
            public DirectoryReader.Result run() throws AccessDeniedException {
                if (prog != null) {
                    prog.setSubText(path);
                }
                return super.run();
            }
        };
        reader.start();
        reader.getOutput().listenAsync(new Task.Cpu<Void, NoException>("DirectoryWalker", priority){

            @Override
            public Void run() {
                if (reader.hasError()) {
                    DirectoryWalker.this.accessDenied(dir, path);
                    if (prog != null) {
                        prog.progress(work);
                    }
                    jp.joined();
                    return null;
                }
                DirectoryReader.Result result = (DirectoryReader.Result)reader.getResult();
                ArrayList<Triple<File, Object, String>> dirs = new ArrayList<Triple<File, Object, String>>(result.nbDirectories);
                for (FileInfo f : result.files) {
                    String p;
                    String string = p = path.length() == 0 ? f.file.getName() : path + '/' + f.file.getName();
                    if (f.isDirectory) {
                        Object o = DirectoryWalker.this.directoryFound(object, f, p);
                        if (o == null) continue;
                        dirs.add(new Triple<File, Object, String>(f.file, o, p));
                        continue;
                    }
                    DirectoryWalker.this.fileFound(object, f, p);
                }
                jp.addToJoin(dirs.size());
                int steps = dirs.size() + 1;
                long step = work / (long)steps--;
                long w = work - step;
                if (prog != null) {
                    prog.progress(step);
                }
                for (Triple triple : dirs) {
                    step = w / (long)steps--;
                    w -= step;
                    DirectoryWalker.this.processDirectory((String)triple.getValue3(), (File)triple.getValue1(), triple.getValue2(), jp, priority, prog, step);
                }
                jp.joined();
                return null;
            }
        }, true);
    }
}

