/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;

public class ObjectBank<T>
implements IMemoryManageable,
Closeable {
    private ArrayList<T> bank;
    private int maxSize;
    private String description;

    public ObjectBank(int maxSize, String description) {
        this.maxSize = maxSize;
        this.bank = new ArrayList(maxSize);
        this.description = description;
        MemoryManager.register(this);
    }

    @Override
    public void close() {
        MemoryManager.unregister(this);
        this.bank = null;
    }

    public synchronized T get() {
        if (this.bank.isEmpty()) {
            return null;
        }
        return this.bank.remove(this.bank.size() - 1);
    }

    public synchronized void free(T object) {
        if (this.bank.size() == this.maxSize) {
            return;
        }
        this.bank.add(object);
    }

    @Override
    public String getDescription() {
        return "Cached list of " + this.description + " (" + this.bank.size() + " items)";
    }

    @Override
    public List<String> getItemsDescription() {
        return null;
    }

    @Override
    public synchronized void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        int nb;
        if (this.bank.isEmpty()) {
            return;
        }
        switch (level) {
            default: {
                nb = this.bank.size() / 10;
                if (nb != 0) break;
                nb = 1;
                break;
            }
            case MEDIUM: {
                nb = this.bank.size() / 3;
                if (nb != 0) break;
                nb = 1;
                break;
            }
            case URGENT: {
                nb = this.bank.size();
            }
        }
        while (nb-- > 0) {
            this.bank.remove(this.bank.size() - 1);
        }
    }
}

