/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.collections.sort.RedBlackTreeInteger;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;

public class IntArrayCache
implements IMemoryManageable {
    public int maxBuffersBySizeUnder128KB = 20;
    public int maxBuffersBySizeAbove128KB = 8;
    public int maxTotalSize = 0x1000000;
    public long timeBeforeToRemove = 300000L;
    private RedBlackTreeInteger<ArraysBySize> arraysBySize = new RedBlackTreeInteger();
    private int totalSize = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IntArrayCache getInstance() {
        Application app = LCCore.getApplication();
        Class<IntArrayCache> clazz = IntArrayCache.class;
        synchronized (IntArrayCache.class) {
            IntArrayCache instance = app.getInstance(IntArrayCache.class);
            if (instance != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
            instance = new IntArrayCache();
            app.setInstance(IntArrayCache.class, instance);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private IntArrayCache() {
        MemoryManager.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] get(int size, boolean acceptGreater) {
        int[] buf;
        RedBlackTreeInteger<ArraysBySize> redBlackTreeInteger = this.arraysBySize;
        synchronized (redBlackTreeInteger) {
            RedBlackTreeInteger.Node<ArraysBySize> node = acceptGreater ? this.arraysBySize.searchNearestHigher(size, true) : this.arraysBySize.get(size);
            if (node != null && acceptGreater && node.getValue() > size * 3 / 2) {
                node = null;
            }
            if (node == null) {
                buf = null;
            } else {
                ArraysBySize arrays = node.getElement();
                arrays.lastUsageTime = System.currentTimeMillis();
                buf = (int[])arrays.arrays.poll();
            }
        }
        if (buf == null) {
            return new int[size];
        }
        this.totalSize -= buf.length;
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(int[] array) {
        int len = array.length;
        RedBlackTreeInteger<ArraysBySize> redBlackTreeInteger = this.arraysBySize;
        synchronized (redBlackTreeInteger) {
            if (this.totalSize + len > this.maxTotalSize) {
                return;
            }
            RedBlackTreeInteger.Node<ArraysBySize> node = this.arraysBySize.get(len);
            if (node == null) {
                ArraysBySize arrays = new ArraysBySize();
                arrays.arrays = new TurnArray(len >= 131072 ? this.maxBuffersBySizeAbove128KB : this.maxBuffersBySizeUnder128KB);
                arrays.arrays.add(array);
                arrays.lastCachedTime = System.currentTimeMillis();
                this.arraysBySize.add(len, arrays);
                this.totalSize += len;
                return;
            }
            ArraysBySize arrays = node.getElement();
            arrays.lastCachedTime = System.currentTimeMillis();
            if (arrays.arrays.isFull()) {
                return;
            }
            this.totalSize += len;
            arrays.arrays.add(array);
        }
    }

    @Override
    public String getDescription() {
        return "int arrays cache";
    }

    @Override
    public List<String> getItemsDescription() {
        return Arrays.asList("Total cached size: " + this.totalSize * 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        long now = System.currentTimeMillis();
        switch (level) {
            default: {
                this.freeMemory(now - this.timeBeforeToRemove, 1);
                break;
            }
            case LOW: {
                this.freeMemory(now - this.timeBeforeToRemove / 2L, 2);
                break;
            }
            case MEDIUM: {
                this.freeMemory(now - this.timeBeforeToRemove / 3L, 5);
                break;
            }
            case URGENT: {
                RedBlackTreeInteger<ArraysBySize> redBlackTreeInteger = this.arraysBySize;
                synchronized (redBlackTreeInteger) {
                    this.arraysBySize.clear();
                    this.totalSize = 0;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeMemory(long beforeTime, int nbToRemove) {
        LinkedList<RedBlackTreeInteger.Node> toRemove = new LinkedList<RedBlackTreeInteger.Node>();
        RedBlackTreeInteger<ArraysBySize> redBlackTreeInteger = this.arraysBySize;
        synchronized (redBlackTreeInteger) {
            Iterator<RedBlackTreeInteger.Node<ArraysBySize>> it = this.arraysBySize.nodeIterator();
            while (it.hasNext()) {
                RedBlackTreeInteger.Node node = it.next();
                ArraysBySize arrays = node.getElement();
                if (arrays.lastUsageTime >= beforeTime || arrays.lastCachedTime > beforeTime && arrays.arrays.size() <= 2) continue;
                for (int i = 0; i < nbToRemove && !arrays.arrays.isEmpty(); ++i) {
                    arrays.arrays.poll();
                    this.totalSize -= node.getValue();
                }
                if (!arrays.arrays.isEmpty()) continue;
                toRemove.add(node);
            }
            for (RedBlackTreeInteger.Node node : toRemove) {
                this.arraysBySize.remove(node);
            }
        }
    }

    private static class ArraysBySize {
        private TurnArray<int[]> arrays;
        private long lastCachedTime;
        private long lastUsageTime;

        private ArraysBySize() {
        }
    }
}

